/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wisesecurity.kfs.crypto.signer;

import com.huawei.wisesecurity.kfs.crypto.codec.Decoder;
import com.huawei.wisesecurity.kfs.crypto.codec.Encoder;
import com.huawei.wisesecurity.kfs.crypto.key.KeyStoreProvider;
import com.huawei.wisesecurity.kfs.crypto.signer.SignHandler;
import com.huawei.wisesecurity.kfs.crypto.signer.SignText;
import com.huawei.wisesecurity.kfs.exception.CodecException;
import com.huawei.wisesecurity.kfs.exception.CryptoException;
import com.huawei.wisesecurity.kfs.util.ByteUtil;
import com.huawei.wisesecurity.ucs_credential.f;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Mac;

public class DefaultSignHandler
implements SignHandler {
    private final Key key;
    private final AlgorithmParameterSpec parameterSpec;
    private final SignText signText;
    private final KeyStoreProvider provider;

    public DefaultSignHandler(Key key, SignText signText, AlgorithmParameterSpec algorithmParameterSpec) {
        this.provider = KeyStoreProvider.ANDROID_KEYSTORE;
        this.key = key;
        this.parameterSpec = algorithmParameterSpec;
        this.signText = signText;
    }

    public DefaultSignHandler(KeyStoreProvider keyStoreProvider, Key key, SignText signText, AlgorithmParameterSpec algorithmParameterSpec) {
        this.provider = keyStoreProvider;
        this.key = key;
        this.parameterSpec = algorithmParameterSpec;
        this.signText = signText;
    }

    private DefaultSignHandler from(String string, Decoder decoder) throws CryptoException {
        DefaultSignHandler defaultSignHandler;
        try {
            DefaultSignHandler defaultSignHandler2 = this;
            defaultSignHandler = defaultSignHandler2;
            defaultSignHandler2.from(decoder.decode(string));
        }
        catch (CodecException codecException) {
            throw new CryptoException(f.a("Fail to decode plain text : ").append(codecException.getMessage()).toString());
        }
        return defaultSignHandler;
    }

    private void doSign() throws CryptoException {
        switch (1.$SwitchMap$com$huawei$wisesecurity$kfs$crypto$signer$SignAlg[this.signText.getAlgId().ordinal()]) {
            default: {
                throw new CryptoException(f.a("unsupported sign alg : ").append(this.signText.getAlgId().getTransformation()).toString());
            }
            case 4: {
                this.doSymmSign();
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                this.doAsymmSign();
            }
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void doAsymmSign() throws CryptoException {
        block14: {
            v0 = this;
            v1 = v0;
            var1_7 = v0.signText.getAlgId().getTransformation();
            var2_8 /* !! */  = v1.provider;
            if (var2_8 /* !! */  != KeyStoreProvider.ANDROID_KEYSTORE) break block14;
            v2 = Signature.getInstance((String)var1_7);
lbl11:
            // 2 sources

            while (true) {
                var1_7 = v2;
                ** GOTO lbl18
                break;
            }
        }
        v2 = Signature.getInstance((String)var1_7, var2_8 /* !! */ .getProviderName());
        ** continue;
lbl18:
        // 1 sources

        var2_8 /* !! */  = this.parameterSpec;
        if (var2_8 /* !! */  == null) ** GOTO lbl22
        var1_7.setParameter((AlgorithmParameterSpec)var2_8 /* !! */ );
lbl22:
        // 2 sources

        var2_8 /* !! */  = this.key;
        if (!(var2_8 /* !! */  instanceof PrivateKey)) ** GOTO lbl30
        try {
            var1_7.initSign((PrivateKey)var2_8 /* !! */ );
            var1_7.update(this.signText.getDataBytes());
            this.signText.setSignature(var1_7.sign());
            return;
lbl30:
            // 1 sources

            throw new CryptoException("sign key not private key");
        }
        catch (NoSuchProviderException var0_1) {
        }
        catch (SignatureException var0_2) {
        }
        catch (InvalidAlgorithmParameterException var0_3) {
        }
        catch (InvalidKeyException var0_4) {
        }
        catch (NoSuchAlgorithmException var0_5) {
            // empty catch block
        }
        throw new CryptoException(f.a("Fail to sign : ").append(var0_6.getMessage()).toString());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doSymmSign() throws CryptoException {
        void var0_4;
        try {
            DefaultSignHandler defaultSignHandler = this;
            Object object = defaultSignHandler.signText.getAlgId().getTransformation();
            KeyStoreProvider keyStoreProvider = defaultSignHandler.provider;
            object = keyStoreProvider == KeyStoreProvider.ANDROID_KEYSTORE ? Mac.getInstance((String)object) : Mac.getInstance((String)object, keyStoreProvider.getProviderName());
            ((Mac)object).init(this.key);
            ((Mac)object).update(this.signText.getDataBytes());
            this.signText.setSignature(((Mac)object).doFinal());
            return;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new CryptoException(f.a("Fail to sign : ").append(var0_4.getMessage()).toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CryptoException(f.a("Fail to sign : ").append(var0_4.getMessage()).toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        throw new CryptoException(f.a("Fail to sign : ").append(var0_4.getMessage()).toString());
    }

    private String sign(Encoder encoder) throws CryptoException {
        try {
            DefaultSignHandler defaultSignHandler = this;
            defaultSignHandler.doSign();
            return encoder.encode(defaultSignHandler.signText.getSignature());
        }
        catch (CodecException codecException) {
            throw new CryptoException(f.a("Fail to encode signature bytes: ").append(codecException.getMessage()).toString());
        }
    }

    @Override
    public DefaultSignHandler from(byte[] byArray) throws CryptoException {
        DefaultSignHandler defaultSignHandler = this;
        defaultSignHandler.signText.setDataBytes(ByteUtil.clone(byArray));
        return defaultSignHandler;
    }

    @Override
    public DefaultSignHandler from(String string) throws CryptoException {
        return this.from(string.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public DefaultSignHandler fromBase64(String string) throws CryptoException {
        return this.from(string, Decoder.BASE64);
    }

    @Override
    public DefaultSignHandler fromBase64Url(String string) throws CryptoException {
        return this.from(string, Decoder.BASE64URL);
    }

    @Override
    public DefaultSignHandler fromHex(String string) throws CryptoException {
        return this.from(string, Decoder.HEX);
    }

    @Override
    public byte[] sign() throws CryptoException {
        DefaultSignHandler defaultSignHandler = this;
        defaultSignHandler.doSign();
        return defaultSignHandler.signText.getSignature();
    }

    @Override
    public String signBase64() throws CryptoException {
        return this.sign(Encoder.BASE64);
    }

    @Override
    public String signBase64Url() throws CryptoException {
        return this.sign(Encoder.BASE64URL);
    }

    @Override
    public String signHex() throws CryptoException {
        return this.sign(Encoder.HEX);
    }
}

