/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wisesecurity.kfs.crypto.signer;

import com.huawei.wisesecurity.kfs.crypto.codec.Decoder;
import com.huawei.wisesecurity.kfs.crypto.key.KeyStoreProvider;
import com.huawei.wisesecurity.kfs.crypto.signer.SignText;
import com.huawei.wisesecurity.kfs.crypto.signer.VerifyHandler;
import com.huawei.wisesecurity.kfs.exception.CodecException;
import com.huawei.wisesecurity.kfs.exception.CryptoException;
import com.huawei.wisesecurity.ucs_credential.f;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Mac;

public class DefaultVerifyHandler
implements VerifyHandler {
    private final Key key;
    private final AlgorithmParameterSpec parameterSpec;
    private final SignText signText;
    private final KeyStoreProvider provider;

    public DefaultVerifyHandler(Key key, SignText signText, AlgorithmParameterSpec algorithmParameterSpec) {
        this.provider = KeyStoreProvider.ANDROID_KEYSTORE;
        this.key = key;
        this.parameterSpec = algorithmParameterSpec;
        this.signText = signText;
    }

    public DefaultVerifyHandler(KeyStoreProvider keyStoreProvider, Key key, SignText signText, AlgorithmParameterSpec algorithmParameterSpec) {
        this.provider = keyStoreProvider;
        this.key = key;
        this.parameterSpec = algorithmParameterSpec;
        this.signText = signText;
    }

    private DefaultVerifyHandler fromData(String string, Decoder decoder) throws CryptoException {
        DefaultVerifyHandler defaultVerifyHandler;
        try {
            DefaultVerifyHandler defaultVerifyHandler2 = this;
            defaultVerifyHandler = defaultVerifyHandler2;
            defaultVerifyHandler2.fromData(decoder.decode(string));
        }
        catch (CodecException codecException) {
            throw new CryptoException(f.a("Fail to decode sign data: ").append(codecException.getMessage()).toString());
        }
        return defaultVerifyHandler;
    }

    private boolean verify(String string, Decoder decoder) throws CryptoException {
        try {
            return this.verify(decoder.decode(string));
        }
        catch (CodecException codecException) {
            throw new CryptoException(f.a("Fail to decode signature : ").append(codecException.getMessage()).toString());
        }
    }

    private boolean doVerify() throws CryptoException {
        switch (1.$SwitchMap$com$huawei$wisesecurity$kfs$crypto$signer$SignAlg[this.signText.getAlgId().ordinal()]) {
            default: {
                throw new CryptoException(f.a("unsupported sign alg : ").append(this.signText.getAlgId().getTransformation()).toString());
            }
            case 4: {
                return this.doSymmVerify();
            }
            case 1: 
            case 2: 
            case 3: 
        }
        return this.doAsymmVerify();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private boolean doAsymmVerify() throws CryptoException {
        block14: {
            v0 = this;
            v1 = v0;
            var1_7 = v0.signText.getAlgId().getTransformation();
            var2_8 /* !! */  = v1.provider;
            if (var2_8 /* !! */  != KeyStoreProvider.ANDROID_KEYSTORE) break block14;
            v2 = Signature.getInstance((String)var1_7);
lbl11:
            // 2 sources

            while (true) {
                var1_7 = v2;
                ** GOTO lbl18
                break;
            }
        }
        v2 = Signature.getInstance((String)var1_7, var2_8 /* !! */ .getProviderName());
        ** continue;
lbl18:
        // 1 sources

        var2_8 /* !! */  = this.parameterSpec;
        if (var2_8 /* !! */  == null) ** GOTO lbl22
        var1_7.setParameter((AlgorithmParameterSpec)var2_8 /* !! */ );
lbl22:
        // 2 sources

        var2_8 /* !! */  = this.key;
        if (!(var2_8 /* !! */  instanceof PublicKey)) ** GOTO lbl29
        try {
            var1_7.initVerify((PublicKey)var2_8 /* !! */ );
            var1_7.update(this.signText.getDataBytes());
            return var1_7.verify(this.signText.getSignature());
lbl29:
            // 1 sources

            throw new CryptoException("verify key not public key");
        }
        catch (NoSuchProviderException var0_1) {
        }
        catch (SignatureException var0_2) {
        }
        catch (InvalidAlgorithmParameterException var0_3) {
        }
        catch (InvalidKeyException var0_4) {
        }
        catch (NoSuchAlgorithmException var0_5) {
            // empty catch block
        }
        throw new CryptoException(f.a("Fail to decrypt: ").append(var0_6.getMessage()).toString());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doSymmVerify() throws CryptoException {
        void var0_4;
        try {
            DefaultVerifyHandler defaultVerifyHandler = object2;
            Object object = defaultVerifyHandler.signText.getAlgId().getTransformation();
            KeyStoreProvider keyStoreProvider = defaultVerifyHandler.provider;
            object = keyStoreProvider == KeyStoreProvider.ANDROID_KEYSTORE ? Mac.getInstance((String)object) : Mac.getInstance((String)object, keyStoreProvider.getProviderName());
            DefaultVerifyHandler defaultVerifyHandler2 = object2;
            ((Mac)object).init(((DefaultVerifyHandler)object2).key);
            ((Mac)object).update(((DefaultVerifyHandler)object2).signText.getDataBytes());
            Object object2 = ((DefaultVerifyHandler)object2).signText.getSignature();
            return defaultVerifyHandler2.checkSignature((byte[])object2, ((Mac)object).doFinal());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new CryptoException(f.a("Fail to sign : ").append(var0_4.getMessage()).toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CryptoException(f.a("Fail to sign : ").append(var0_4.getMessage()).toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        throw new CryptoException(f.a("Fail to sign : ").append(var0_4.getMessage()).toString());
    }

    private boolean checkSignature(byte[] byArray, byte[] byArray2) {
        if (byArray != null && byArray2 != null && byArray.length == byArray2.length) {
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                if (byArray[i2] == byArray2[i2]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public DefaultVerifyHandler fromData(byte[] byArray) throws CryptoException {
        DefaultVerifyHandler defaultVerifyHandler = this;
        defaultVerifyHandler.signText.setDataBytes(byArray);
        return defaultVerifyHandler;
    }

    @Override
    public DefaultVerifyHandler fromData(String string) throws CryptoException {
        return this.fromData(string.getBytes(Charset.forName("UTF-8")));
    }

    @Override
    public DefaultVerifyHandler fromBase64Data(String string) throws CryptoException {
        return this.fromData(string, Decoder.BASE64);
    }

    @Override
    public DefaultVerifyHandler fromBase64UrlData(String string) throws CryptoException {
        return this.fromData(string, Decoder.BASE64URL);
    }

    @Override
    public DefaultVerifyHandler fromHexData(String string) throws CryptoException {
        return this.fromData(string, Decoder.HEX);
    }

    @Override
    public boolean verify(byte[] byArray) throws CryptoException {
        DefaultVerifyHandler defaultVerifyHandler = this;
        defaultVerifyHandler.signText.setSignature(byArray);
        return defaultVerifyHandler.doVerify();
    }

    @Override
    public boolean verify(String string) throws CryptoException {
        return this.verify(string.getBytes(Charset.forName("UTF-8")));
    }

    @Override
    public boolean verifyBase64(String string) throws CryptoException {
        return this.verify(string, Decoder.BASE64);
    }

    @Override
    public boolean verifyBase64Url(String string) throws CryptoException {
        return this.verify(string, Decoder.BASE64URL);
    }

    @Override
    public boolean verifyHex(String string) throws CryptoException {
        return this.verify(string, Decoder.HEX);
    }
}

