/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wisesecurity.kfs.crypto.signer;

import com.huawei.wisesecurity.kfs.crypto.key.KeyStoreProvider;
import com.huawei.wisesecurity.kfs.crypto.signer.KfsSigner;
import com.huawei.wisesecurity.kfs.crypto.signer.SignAlg;
import com.huawei.wisesecurity.kfs.crypto.signer.ec.ECSigner;
import com.huawei.wisesecurity.kfs.crypto.signer.hmac.HmacSigner;
import com.huawei.wisesecurity.kfs.crypto.signer.rsa.RSASigner;
import com.huawei.wisesecurity.kfs.exception.CryptoException;
import com.huawei.wisesecurity.ucs_credential.f;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;

public class SignerFactory {
    private SignerFactory() {
    }

    public static KfsSigner getSigner(SignAlg signAlg, Key key, AlgorithmParameterSpec algorithmParameterSpec) throws CryptoException {
        return SignerFactory.getSigner(KeyStoreProvider.ANDROID_KEYSTORE, signAlg, key, algorithmParameterSpec);
    }

    public static KfsSigner getSigner(KeyStoreProvider keyStoreProvider, SignAlg signAlg, Key key, AlgorithmParameterSpec algorithmParameterSpec) throws CryptoException {
        switch (1.$SwitchMap$com$huawei$wisesecurity$kfs$crypto$signer$SignAlg[signAlg.ordinal()]) {
            default: {
                throw new CryptoException(f.a("unsupported alg : ").append(signAlg.getTransformation()).toString());
            }
            case 4: {
                return new HmacSigner.Builder(keyStoreProvider).withAlg(signAlg).withKey(key).build();
            }
            case 3: {
                return (KfsSigner)new ECSigner.Builder(keyStoreProvider).withAlg(signAlg).withKey(key).build();
            }
            case 1: 
            case 2: 
        }
        return (KfsSigner)new RSASigner.Builder(keyStoreProvider).withAlg(signAlg).withKey(key).withParameterSpec(algorithmParameterSpec).build();
    }
}

