/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wisesecurity.kfs.crypto.signer.ec;

import com.huawei.wisesecurity.kfs.crypto.key.KeyStoreProvider;
import com.huawei.wisesecurity.kfs.crypto.signer.AsymmetricSignerBuilder;
import com.huawei.wisesecurity.kfs.crypto.signer.DefaultSignHandler;
import com.huawei.wisesecurity.kfs.crypto.signer.DefaultVerifyHandler;
import com.huawei.wisesecurity.kfs.crypto.signer.KfsSigner;
import com.huawei.wisesecurity.kfs.crypto.signer.SignAlg;
import com.huawei.wisesecurity.kfs.crypto.signer.SignHandler;
import com.huawei.wisesecurity.kfs.crypto.signer.SignText;
import com.huawei.wisesecurity.kfs.crypto.signer.VerifyHandler;
import com.huawei.wisesecurity.kfs.exception.CryptoException;
import java.security.PrivateKey;
import java.security.PublicKey;

public class ECSigner
implements KfsSigner {
    private final SignAlg signAlg;
    private final PrivateKey privateKey;
    private final PublicKey publicKey;
    private final KeyStoreProvider provider;

    private ECSigner(KeyStoreProvider keyStoreProvider, SignAlg signAlg, PrivateKey privateKey, PublicKey publicKey) {
        this.provider = keyStoreProvider;
        this.signAlg = signAlg;
        this.privateKey = privateKey;
        this.publicKey = publicKey;
    }

    public /* synthetic */ ECSigner(KeyStoreProvider keyStoreProvider, SignAlg signAlg, PrivateKey privateKey, PublicKey publicKey, 1 var5_5) {
        this(keyStoreProvider, signAlg, privateKey, publicKey);
    }

    @Override
    public SignHandler getSignHandler() throws CryptoException {
        SignText signText;
        SignText signText2 = signText;
        signText2();
        signText.setAlgId(this.signAlg);
        PrivateKey privateKey = this.privateKey;
        if (privateKey != null) {
            return new DefaultSignHandler(this.provider, privateKey, signText2, null);
        }
        throw new CryptoException("privateKey is invalid.");
    }

    @Override
    public VerifyHandler getVerifyHandler() throws CryptoException {
        SignText signText;
        SignText signText2 = signText;
        signText2();
        signText.setAlgId(this.signAlg);
        PublicKey publicKey = this.publicKey;
        if (publicKey != null) {
            return new DefaultVerifyHandler(this.provider, publicKey, signText2, null);
        }
        throw new CryptoException("publicKey is invalid.");
    }

    public static class Builder
    extends AsymmetricSignerBuilder<ECSigner> {
        public Builder() {
            this(KeyStoreProvider.ANDROID_KEYSTORE);
        }

        public Builder(KeyStoreProvider keyStoreProvider) {
            Builder builder = this;
            super(keyStoreProvider);
            builder.withAlg(SignAlg.getPreferredAlg("EC"));
        }

        @Override
        public ECSigner build() throws CryptoException {
            Builder builder = object;
            Object object = builder.keyStoreProvider;
            SignAlg signAlg = builder.signAlg;
            PrivateKey privateKey = builder.privateKey;
            PublicKey publicKey = builder.publicKey;
            return new ECSigner((KeyStoreProvider)((Object)object), signAlg, privateKey, publicKey, null);
        }
    }
}

