/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wisesecurity.kfs.crypto.signer.hmac;

import com.huawei.wisesecurity.kfs.crypto.key.KeyStoreProvider;
import com.huawei.wisesecurity.kfs.crypto.signer.DefaultSignHandler;
import com.huawei.wisesecurity.kfs.crypto.signer.DefaultVerifyHandler;
import com.huawei.wisesecurity.kfs.crypto.signer.KfsSigner;
import com.huawei.wisesecurity.kfs.crypto.signer.SignAlg;
import com.huawei.wisesecurity.kfs.crypto.signer.SignHandler;
import com.huawei.wisesecurity.kfs.crypto.signer.SignText;
import com.huawei.wisesecurity.kfs.crypto.signer.VerifyHandler;
import com.huawei.wisesecurity.kfs.exception.CryptoException;
import com.huawei.wisesecurity.kfs.exception.KfsException;
import com.huawei.wisesecurity.ucs_credential.e;
import com.huawei.wisesecurity.ucs_credential.f;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.crypto.spec.SecretKeySpec;

public class HmacSigner
implements KfsSigner {
    private final SignAlg signAlg;
    private final Key key;
    private final KeyStoreProvider provider;

    private HmacSigner(KeyStoreProvider keyStoreProvider, SignAlg signAlg, Key key) {
        this.provider = keyStoreProvider;
        this.signAlg = signAlg;
        this.key = key;
    }

    public /* synthetic */ HmacSigner(KeyStoreProvider keyStoreProvider, SignAlg signAlg, Key key, 1 var4_4) {
        this(keyStoreProvider, signAlg, key);
    }

    @Override
    public SignHandler getSignHandler() throws CryptoException {
        SignText signText;
        SignText signText2 = signText;
        signText2();
        signText.setAlgId(object.signAlg);
        HmacSigner hmacSigner = object;
        Object object = hmacSigner.provider;
        return new DefaultSignHandler((KeyStoreProvider)((Object)object), hmacSigner.key, signText2, null);
    }

    @Override
    public VerifyHandler getVerifyHandler() throws CryptoException {
        SignText signText;
        SignText signText2 = signText;
        signText2();
        signText.setAlgId(object.signAlg);
        HmacSigner hmacSigner = object;
        Object object = hmacSigner.provider;
        return new DefaultVerifyHandler((KeyStoreProvider)((Object)object), hmacSigner.key, signText2, null);
    }

    public static class Builder {
        private SignAlg signAlg = SignAlg.getPreferredAlg("HMAC");
        private Key key;
        private final KeyStoreProvider keyStoreProvider;

        public Builder() {
            this.keyStoreProvider = KeyStoreProvider.ANDROID_KEYSTORE;
        }

        public Builder(KeyStoreProvider keyStoreProvider) {
            this.keyStoreProvider = keyStoreProvider;
        }

        public Builder withAlg(SignAlg signAlg) {
            this.signAlg = signAlg;
            return this;
        }

        public Builder withKey(byte[] byArray) {
            this.key = new SecretKeySpec(byArray, this.signAlg.getTransformation());
            return this;
        }

        public Builder withKey(Key key) {
            this.key = key;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withKeyStoreAlias(String string) throws KfsException {
            void var0_6;
            Builder builder = this;
            Builder builder2 = builder;
            Builder builder3 = builder;
            KeyStore keyStore = KeyStore.getInstance(builder.keyStoreProvider.getName());
            try {
                keyStore.load(null);
                builder3.key = keyStore.getKey(string, null);
                return builder2;
            }
            catch (IOException iOException) {
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
            catch (UnrecoverableKeyException unrecoverableKeyException) {
            }
            catch (CertificateException certificateException) {
            }
            catch (KeyStoreException keyStoreException) {
                // empty catch block
            }
            throw new KfsException(e.a((Exception)var0_6, f.a("keystore get key with alias failed, ")));
        }

        public HmacSigner build() throws CryptoException {
            Key key = object.key;
            if (key != null) {
                Builder builder = object;
                Object object = builder.keyStoreProvider;
                return new HmacSigner((KeyStoreProvider)((Object)object), builder.signAlg, key, null);
            }
            throw new CryptoException("key cannot be null");
        }
    }
}

