/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wisesecurity.kfs.crypto.signer.rsa;

import com.huawei.wisesecurity.kfs.crypto.key.KeyStoreProvider;
import com.huawei.wisesecurity.kfs.crypto.signer.AsymmetricSignerBuilder;
import com.huawei.wisesecurity.kfs.crypto.signer.DefaultSignHandler;
import com.huawei.wisesecurity.kfs.crypto.signer.DefaultVerifyHandler;
import com.huawei.wisesecurity.kfs.crypto.signer.KfsSigner;
import com.huawei.wisesecurity.kfs.crypto.signer.SignAlg;
import com.huawei.wisesecurity.kfs.crypto.signer.SignHandler;
import com.huawei.wisesecurity.kfs.crypto.signer.SignText;
import com.huawei.wisesecurity.kfs.crypto.signer.VerifyHandler;
import com.huawei.wisesecurity.kfs.exception.CryptoException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;

public class RSASigner
implements KfsSigner {
    private final SignAlg signAlg;
    private final KeyStoreProvider provider;
    private final PrivateKey privateKey;
    private final PublicKey publicKey;
    private final AlgorithmParameterSpec parameterSpec;

    private RSASigner(KeyStoreProvider keyStoreProvider, SignAlg signAlg, PrivateKey privateKey, PublicKey publicKey, AlgorithmParameterSpec algorithmParameterSpec) {
        this.provider = keyStoreProvider;
        this.signAlg = signAlg;
        this.privateKey = privateKey;
        this.publicKey = publicKey;
        this.parameterSpec = algorithmParameterSpec;
    }

    public /* synthetic */ RSASigner(KeyStoreProvider keyStoreProvider, SignAlg signAlg, PrivateKey privateKey, PublicKey publicKey, AlgorithmParameterSpec algorithmParameterSpec, 1 var6_6) {
        this(keyStoreProvider, signAlg, privateKey, publicKey, algorithmParameterSpec);
    }

    @Override
    public SignHandler getSignHandler() throws CryptoException {
        SignText signText;
        SignText signText2 = signText;
        signText2();
        signText.setAlgId(object.signAlg);
        PrivateKey privateKey = object.privateKey;
        if (privateKey != null) {
            RSASigner rSASigner = object;
            Object object = rSASigner.provider;
            AlgorithmParameterSpec algorithmParameterSpec = rSASigner.parameterSpec;
            return new DefaultSignHandler((KeyStoreProvider)((Object)object), privateKey, signText2, algorithmParameterSpec);
        }
        throw new CryptoException("privateKey is invalid.");
    }

    @Override
    public VerifyHandler getVerifyHandler() throws CryptoException {
        SignText signText;
        SignText signText2 = signText;
        signText2();
        signText.setAlgId(object.signAlg);
        PublicKey publicKey = object.publicKey;
        if (publicKey != null) {
            RSASigner rSASigner = object;
            Object object = rSASigner.provider;
            AlgorithmParameterSpec algorithmParameterSpec = rSASigner.parameterSpec;
            return new DefaultVerifyHandler((KeyStoreProvider)((Object)object), publicKey, signText2, algorithmParameterSpec);
        }
        throw new CryptoException("publicKey is invalid.");
    }

    public static class Builder
    extends AsymmetricSignerBuilder<RSASigner> {
        public Builder() {
            this(KeyStoreProvider.ANDROID_KEYSTORE);
        }

        public Builder(KeyStoreProvider keyStoreProvider) {
            Builder builder = this;
            super(keyStoreProvider);
            builder.withAlg(SignAlg.getPreferredAlg("RSA"));
        }

        @Override
        public RSASigner build() throws CryptoException {
            Builder builder = object;
            Object object = builder.keyStoreProvider;
            SignAlg signAlg = builder.signAlg;
            PrivateKey privateKey = builder.privateKey;
            PublicKey publicKey = builder.publicKey;
            AlgorithmParameterSpec algorithmParameterSpec = builder.parameterSpec;
            return new RSASigner((KeyStoreProvider)((Object)object), signAlg, privateKey, publicKey, algorithmParameterSpec, null);
        }
    }
}

