/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wisesecurity.kfs.ha;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.text.TextUtils;
import com.huawei.wisesecurity.kfs.log.ILogKfs;
import com.huawei.wisesecurity.kfs.util.PropertyUtil;
import java.util.Locale;

class BIChecker {
    private static final String TAG = "BIChecker";
    private static int isOobe = -1;
    private final ILogKfs kfsLog;
    private boolean isOobeCheck = true;

    public BIChecker(ILogKfs iLogKfs) {
        this.kfsLog = iLogKfs;
    }

    private static void setIsOobe(int n2) {
        isOobe = n2;
    }

    private boolean isChinaROM() {
        String string = ((BIChecker)this).getProductRegion();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return "cn".equalsIgnoreCase(string);
        }
        string = ((BIChecker)this).getProductLocal();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return string.toLowerCase(Locale.US).contains("cn");
        }
        if (!TextUtils.isEmpty((CharSequence)(this = ((BIChecker)this).getLocalCountry()))) {
            return "cn".equalsIgnoreCase((String)this);
        }
        return false;
    }

    private boolean isHuawei() {
        return "HUAWEI".equalsIgnoreCase(Build.MANUFACTURER);
    }

    private String getProductRegion() {
        return PropertyUtil.getSystemProperties("ro.product.locale.region", "");
    }

    private String getProductLocal() {
        return PropertyUtil.getSystemProperties("ro.product.locale", "");
    }

    private String getLocalCountry() {
        return Locale.getDefault().getCountry();
    }

    public void setOobeCheckOn() {
        this.isOobeCheck = true;
    }

    public void setOobeCheckOff() {
        this.isOobeCheck = false;
    }

    public boolean hasError(Context context) {
        if (!this.isOobeCheck) {
            this.kfsLog.i(TAG, "oobe check is off, report is on");
            return false;
        }
        if (!this.isHuawei()) {
            this.kfsLog.i(TAG, "not huawei device, report is on");
            return false;
        }
        if (context == null) {
            return true;
        }
        if (!this.isChinaROM()) {
            this.kfsLog.i(TAG, "not ChinaROM");
            try {
                BIChecker.setIsOobe(Settings.Secure.getInt((ContentResolver)context.getContentResolver(), (String)"hw_app_analytics_state"));
                this.kfsLog.i(TAG, "hw_app_analytics_state value is " + isOobe);
                return isOobe != 1;
            }
            catch (Settings.SettingNotFoundException settingNotFoundException) {
                this.kfsLog.i(TAG, "Get OOBE failed");
                return true;
            }
        }
        return isOobe == 0;
    }
}

