/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wisesecurity.kfs.ha;

import android.content.Context;
import android.text.TextUtils;
import com.huawei.hianalytics.process.HiAnalyticsConfig;
import com.huawei.hianalytics.process.HiAnalyticsInstance;
import com.huawei.wisesecurity.kfs.exception.ParamException;
import com.huawei.wisesecurity.kfs.ha.BIChecker;
import com.huawei.wisesecurity.kfs.ha.HiAnalyticsType;
import com.huawei.wisesecurity.kfs.ha.message.ReportMsgBuilder;
import com.huawei.wisesecurity.kfs.log.ILogKfs;
import com.huawei.wisesecurity.ucs_credential.f;
import java.util.LinkedHashMap;

public class HaReporter {
    private static final String TAG = "HaReporter";
    private static final String WISESECURITY_HA_COMMON_APPID = "com.huawei.wisesecurity.common";
    private HiAnalyticsInstance analyticsInstance;
    private final BIChecker biChecker;
    private final ILogKfs kfsLog;

    public HaReporter(Context context, String string, String string2, ILogKfs iLogKfs) throws ParamException {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.kfsLog = iLogKfs;
            iLogKfs.i(TAG, "hiAnalyticsUrl is " + string2);
            this.biChecker = new BIChecker(iLogKfs);
            this.initHaInstance(string2, context, string);
            return;
        }
        throw new ParamException("hiAnalyticsUrl is empty");
    }

    private void initHaInstance(String string, Context context, String string2) {
        string = new HiAnalyticsConfig.Builder().setCollectURL(string).setEnableUUID(false).build();
        this.analyticsInstance = new HiAnalyticsInstance.Builder(context).setMaintConf((HiAnalyticsConfig)string).setOperConf((HiAnalyticsConfig)string).refresh(string2);
        this.analyticsInstance.setAppid(WISESECURITY_HA_COMMON_APPID);
    }

    public void setOobeCheckOn() {
        this.biChecker.setOobeCheckOn();
    }

    public void setOobeCheckOff() {
        this.biChecker.setOobeCheckOff();
    }

    public void setAppid(String string) {
        this.analyticsInstance.setAppid(string);
    }

    public void onEvent(Context context, ReportMsgBuilder reportMsgBuilder) {
        HaReporter haReporter = object;
        Object object = HiAnalyticsType.HIANALYTICS_MAINTENANCE;
        haReporter.onEvent(context, reportMsgBuilder, (HiAnalyticsType)((Object)object));
    }

    public void onReport(Context context) {
        this.onReport(context, HiAnalyticsType.HIANALYTICS_MAINTENANCE);
    }

    public void onEvent(Context context, ReportMsgBuilder object, HiAnalyticsType object2) {
        if (this.analyticsInstance == null) {
            this.kfsLog.i(TAG, "onEvent null == analyticsInstance");
            return;
        }
        if (this.biChecker.hasError(context)) {
            this.kfsLog.i(TAG, "onEvent isEnabledUserExperience is false");
            return;
        }
        HaReporter haReporter = this;
        HaReporter haReporter2 = haReporter;
        HiAnalyticsInstance hiAnalyticsInstance = haReporter.analyticsInstance;
        ReportMsgBuilder reportMsgBuilder = object;
        ReportMsgBuilder reportMsgBuilder2 = reportMsgBuilder;
        ReportMsgBuilder reportMsgBuilder3 = reportMsgBuilder;
        int n2 = object2.getCode();
        object = reportMsgBuilder2.getEventId();
        object2 = reportMsgBuilder3.build();
        try {
            hiAnalyticsInstance.onEvent(n2, (String)object, (LinkedHashMap)object2);
            haReporter2.kfsLog.i(TAG, "onEvent success");
        }
        catch (Exception exception) {
            this.kfsLog.w(TAG, f.a("onEvent fail : ").append(exception.getMessage()).toString());
        }
    }

    public void onReport(Context context, HiAnalyticsType hiAnalyticsType) {
        if (this.analyticsInstance == null) {
            this.kfsLog.i(TAG, "onReport null == analyticsInstance");
            return;
        }
        if (this.biChecker.hasError(context)) {
            this.kfsLog.i(TAG, "onReport isEnabledUserExperience is false");
            return;
        }
        try {
            HaReporter haReporter = this;
            haReporter.analyticsInstance.onReport(hiAnalyticsType.getCode());
            haReporter.kfsLog.i(TAG, "onReport success");
        }
        catch (Exception exception) {
            this.kfsLog.w(TAG, f.a("onReport fail : ").append(exception.getMessage()).toString());
        }
    }
}

