/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wisesecurity.kfs.ha.statistic;

import com.huawei.wisesecurity.kfs.exception.KfsException;

public class CallEvent {
    private static final String STORAGE_KEY_SPLIT_FLAG = "_";
    private final String caller;
    private final String apiName;
    private int callTimes = 1;

    public CallEvent(String string, String string2) {
        this.caller = string;
        this.apiName = string2;
    }

    public CallEvent(String string, String string2, int n2) {
        this.caller = string;
        this.apiName = string2;
        this.callTimes = n2;
    }

    public CallEvent(String string, int n2) throws KfsException {
        String[] stringArray = string.split(STORAGE_KEY_SPLIT_FLAG);
        if (stringArray.length == 2) {
            this.caller = stringArray[0];
            this.apiName = stringArray[1];
            this.callTimes = n2;
            return;
        }
        throw new KfsException(100002, "CallEvent get invalid storageKey : " + string);
    }

    public String getStorageKey() {
        return this.caller + STORAGE_KEY_SPLIT_FLAG + this.apiName;
    }

    public String getCaller() {
        return this.caller;
    }

    public String getApiName() {
        return this.apiName;
    }

    public int getCallTimes() {
        return this.callTimes;
    }
}

