/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wisesecurity.kfs.ha.statistic;

import android.content.Context;
import com.huawei.wisesecurity.kfs.exception.KfsException;
import com.huawei.wisesecurity.kfs.ha.statistic.CallEvent;
import com.huawei.wisesecurity.kfs.log.LogKfs;
import com.huawei.wisesecurity.kfs.util.SpUtil;
import com.huawei.wisesecurity.ucs_credential.f;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EventStorage {
    private static final String TAG = "EventStorage";
    public static final String SP_FILE_CALL_STATISTIC = "callStatistic";
    private int reportEventNum = 10;
    private final CallEventKeyStorage keyStorage;
    private final EventCallTimesStorage callTimesStorage;

    public EventStorage(Context object) throws KfsException {
        EventCallTimesStorage eventCallTimesStorage;
        CallEventKeyStorage callEventKeyStorage;
        SpUtil spUtil;
        SpUtil spUtil2 = spUtil;
        spUtil = new SpUtil((Context)object, SP_FILE_CALL_STATISTIC);
        object = callEventKeyStorage;
        callEventKeyStorage = new CallEventKeyStorage(spUtil2);
        v2.keyStorage = object;
        EventCallTimesStorage eventCallTimesStorage2 = eventCallTimesStorage;
        eventCallTimesStorage = new EventCallTimesStorage(spUtil2, ((CallEventKeyStorage)object).getEventCallTimesKeys());
        v2.callTimesStorage = eventCallTimesStorage2;
    }

    public void addSingleCallEvent(CallEvent callEvent) throws KfsException {
        EventStorage eventStorage = this;
        eventStorage.callTimesStorage.addSingleCallEvent(callEvent);
        eventStorage.keyStorage.addEventCallTimesKey(callEvent.getStorageKey());
    }

    public List<CallEvent> getValidCallEvents() throws KfsException {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        for (Map.Entry<String, Integer> entry : ((EventStorage)((Object)arrayList2)).callTimesStorage.getEventCallTimesMap().entrySet()) {
            if (entry.getValue() <= 0) continue;
            arrayList2.add(new CallEvent(entry.getKey(), entry.getValue()));
        }
        return arrayList2;
    }

    public void setReportEventNum(int n2) {
        this.reportEventNum = n2;
    }

    public boolean needReport() {
        Iterator<Map.Entry<String, Integer>> iterator = this.callTimesStorage.getEventCallTimesMap().entrySet().iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getValue() < this.reportEventNum) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.callTimesStorage.clear();
    }

    public static final class CallEventKeyStorage {
        private static final String SP_KEY_EVENT_CALL_TIMES_KEYS = "eventCallTimesKeys";
        private static final String EVENT_CALL_TIMES_KEYS_JSON_KEY = "keys";
        private final List<String> eventCallTimesKeys;
        private final SpUtil spUtil;

        public CallEventKeyStorage(SpUtil spUtil) throws KfsException {
            ArrayList arrayList;
            CallEventKeyStorage callEventKeyStorage = arrayList2;
            ArrayList arrayList2 = arrayList;
            arrayList = new ArrayList();
            callEventKeyStorage.eventCallTimesKeys = arrayList2;
            callEventKeyStorage.spUtil = spUtil;
            callEventKeyStorage.loadEventCallTimesKeys();
        }

        private void loadEventCallTimesKeys() throws KfsException {
            block8: {
                int n2;
                JSONObject jSONObject;
                Object[] objectArray = this.spUtil.getString(SP_KEY_EVENT_CALL_TIMES_KEYS, "{}");
                JSONObject jSONObject2 = jSONObject;
                if (new JSONObject((String)objectArray).isNull(EVENT_CALL_TIMES_KEYS_JSON_KEY)) break block8;
                try {
                    objectArray = jSONObject2.getJSONArray(EVENT_CALL_TIMES_KEYS_JSON_KEY);
                    n2 = 0;
                }
                catch (JSONException jSONException) {
                    String string = f.a("loadEventCallTimesKeys get JSONException \uff1a").append(jSONException.getMessage()).toString();
                    objectArray = new Object[]{};
                    LogKfs.e(EventStorage.TAG, string, objectArray);
                    throw new KfsException(100001, string);
                }
                while (true) {
                    if (n2 >= objectArray.length()) break;
                    this.eventCallTimesKeys.add(objectArray.getString(n2));
                    ++n2;
                }
            }
            return;
        }

        public List<String> getEventCallTimesKeys() {
            return this.eventCallTimesKeys;
        }

        public void addEventCallTimesKey(String jSONObject) throws KfsException {
            CallEventKeyStorage callEventKeyStorage;
            JSONArray jSONArray;
            JSONObject jSONObject2;
            block12: {
                if (!((CallEventKeyStorage)((Object)string)).eventCallTimesKeys.contains(jSONObject)) break block12;
                return;
            }
            CallEventKeyStorage callEventKeyStorage2 = string;
            CallEventKeyStorage callEventKeyStorage3 = callEventKeyStorage2;
            callEventKeyStorage2.eventCallTimesKeys.add((String)jSONObject);
            jSONObject = jSONObject2;
            jSONObject2 = new JSONObject();
            JSONArray jSONArray2 = jSONArray;
            jSONArray = new JSONArray();
            Iterator<String> iterator = callEventKeyStorage3.eventCallTimesKeys.iterator();
            while (true) {
                if (!iterator.hasNext()) break;
                jSONArray2.put((Object)iterator.next());
            }
            try {
                callEventKeyStorage = string;
                jSONObject.put(EVENT_CALL_TIMES_KEYS_JSON_KEY, (Object)jSONArray2);
            }
            catch (JSONException jSONException) {
                String string = f.a("addEventCallTimesKey get JSONException \uff1a").append(jSONException.getMessage()).toString();
                jSONObject = new JSONObject[]{};
                LogKfs.e(EventStorage.TAG, string, (Object[])jSONObject);
                throw new KfsException(100001, string);
            }
            SpUtil spUtil = callEventKeyStorage.spUtil;
            JSONObject jSONObject3 = jSONObject;
            String string = SP_KEY_EVENT_CALL_TIMES_KEYS;
            spUtil.putString(string, jSONObject3.toString());
        }
    }

    public static final class EventCallTimesStorage {
        private final Map<String, Integer> eventCallTimesMap;
        private final SpUtil spUtil;

        public EventCallTimesStorage(SpUtil spUtil, List<String> iterator) {
            HashMap hashMap;
            List<String> list = iterator;
            iterator = hashMap;
            hashMap = new HashMap();
            this.eventCallTimesMap = iterator;
            this.spUtil = spUtil;
            for (String string : list) {
                this.eventCallTimesMap.put(string, spUtil.getInt(string, 0));
            }
        }

        public void addSingleCallEvent(CallEvent callEvent) {
            int n2;
            String string = callEvent.getStorageKey();
            if (this.eventCallTimesMap.containsKey(string)) {
                n2 = this.eventCallTimesMap.get(string);
                n2 = callEvent.getCallTimes() + n2;
            } else {
                n2 = callEvent.getCallTimes();
            }
            EventCallTimesStorage eventCallTimesStorage = this;
            eventCallTimesStorage.eventCallTimesMap.put(string, n2);
            eventCallTimesStorage.spUtil.putInt(string, n2);
        }

        public void clear() {
            Iterator<Map.Entry<String, Integer>> iterator = this.eventCallTimesMap.entrySet().iterator();
            while (iterator.hasNext()) {
                EventCallTimesStorage eventCallTimesStorage = this;
                Map.Entry<String, Integer> entry = iterator.next();
                eventCallTimesStorage.eventCallTimesMap.put(entry.getKey(), 0);
                eventCallTimesStorage.spUtil.putInt(entry.getKey(), 0);
            }
        }

        public Map<String, Integer> getEventCallTimesMap() {
            return this.eventCallTimesMap;
        }
    }
}

