/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wisesecurity.kfs.ha.statistic;

import android.content.Context;
import com.huawei.wisesecurity.kfs.exception.KfsException;
import com.huawei.wisesecurity.kfs.util.SpUtil;

public class TimeStorage {
    private static final String TAG = "TimeStorage";
    private static final String SP_KEY_CALL_STATISTIC_START_TIME = "callStatisticStartTime";
    private long reportPeriod = 1800000L;
    private final SpUtil spUtil;

    public TimeStorage(Context context) {
        SpUtil spUtil;
        SpUtil spUtil2;
        SpUtil spUtil3 = spUtil2 = spUtil;
        spUtil3(context, "callStatistic");
        this.spUtil = spUtil3;
        if (spUtil.getLong(SP_KEY_CALL_STATISTIC_START_TIME, 0L) == 0L) {
            long l2 = System.currentTimeMillis();
            spUtil2.putLong(SP_KEY_CALL_STATISTIC_START_TIME, l2);
        }
    }

    public long getStartTime() throws KfsException {
        long l2 = this.spUtil.getLong(SP_KEY_CALL_STATISTIC_START_TIME, 0L);
        if (l2 != 0L) {
            return l2;
        }
        throw new KfsException(100001, "callStatisticStartTime get failed");
    }

    public void setReportPeriod(long l2) {
        this.reportPeriod = l2;
    }

    public boolean needReport() throws KfsException {
        return System.currentTimeMillis() - this.getStartTime() >= this.reportPeriod;
    }

    public void clear() {
        long l2 = System.currentTimeMillis();
        this.spUtil.putLong(SP_KEY_CALL_STATISTIC_START_TIME, l2);
    }
}

