/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wisesecurity.kfs.interceptors;

import android.os.Build;
import com.huawei.hms.framework.network.restclient.hwhttp.Interceptor;
import com.huawei.hms.framework.network.restclient.hwhttp.RealInterceptorChain;
import com.huawei.hms.framework.network.restclient.hwhttp.Request;
import com.huawei.hms.framework.network.restclient.hwhttp.Response;
import com.huawei.wisesecurity.kfs.exception.ParamException;
import com.huawei.wisesecurity.kfs.interceptors.ArgumentChecker;
import com.huawei.wisesecurity.kfs.interceptors.TerminalType;
import com.huawei.wisesecurity.kfs.util.PropertyUtil;
import com.huawei.wisesecurity.ucs_credential.f;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ReqHeaderInterceptor
implements Interceptor {
    private static final String TAG = "ReqHeaderInterceptor";
    private static final String CLIENT_VERSION_TITLE = "X-Client-Version";
    private static final String CALL_TIME_TITLE = "callTime";
    private static final String TERMINAL_TITLE = "X-Terminal";
    private static final String REQUEST_CONTEXT_TITLE = "X-Request-Context";
    private static final String APP_ID_TITLE = "X-App-ID";
    private static final String EMUI_API_LEVEL_TITLE = "X-Emui-Api-Level";
    private static final String ANDROID_API_LEVEL_TITLE = "X-Android-Api-Level";
    private static final String TERMINAL_TYPE_TITLE = "terminalType";
    private static final String APP_PACKAGE_NAME_TITLE = "appPkgName";
    private static final String KEYPAIR_SEPARATOR = ",";
    private static final String KEY_VALUE_SEPARATOR = "=";
    private final Map<String, String> headers;
    private String packageName;
    private String appId;
    private String serviceVersion;
    private TerminalType terminalType;

    public ReqHeaderInterceptor(Map<String, String> map, String string, String string2, String string3, TerminalType terminalType) throws ParamException {
        HashMap<String, String> hashMap;
        HashMap<String, String> hashMap2 = hashMap;
        ReqHeaderInterceptor reqHeaderInterceptor = this;
        Map<String, String> map2 = map;
        hashMap2();
        this.headers = hashMap2;
        ArgumentChecker.checkNonNull(map2);
        ArgumentChecker.checkHeaderValue(map2);
        ArgumentChecker.checkHeaderValue(string);
        ArgumentChecker.checkHeaderValue(string2);
        ArgumentChecker.checkHeaderValue(string3);
        ArgumentChecker.checkNonNull(terminalType);
        reqHeaderInterceptor.appId = string;
        reqHeaderInterceptor.packageName = string2;
        reqHeaderInterceptor.serviceVersion = string3;
        reqHeaderInterceptor.terminalType = terminalType;
        hashMap.putAll(map);
    }

    private void addCommomHeader(Request.Builder builder) {
        for (Map.Entry<String, String> entry : ((ReqHeaderInterceptor)((Object)string)).headers.entrySet()) {
            builder.addHeader(entry.getKey(), entry.getValue());
        }
        Request.Builder builder2 = builder;
        builder.addHeader(CLIENT_VERSION_TITLE, ((ReqHeaderInterceptor)((Object)string)).serviceVersion);
        builder2.addHeader(TERMINAL_TITLE, ((ReqHeaderInterceptor)((Object)string)).terminalType.getValue());
        String string = String.valueOf(System.currentTimeMillis());
        builder2.addHeader(CALL_TIME_TITLE, string);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(TERMINAL_TYPE_TITLE).append(KEY_VALUE_SEPARATOR).append(Build.MODEL);
        stringBuilder.append(KEYPAIR_SEPARATOR).append(CALL_TIME_TITLE).append(KEY_VALUE_SEPARATOR).append(string);
        builder2.addHeader(REQUEST_CONTEXT_TITLE, stringBuilder.toString());
    }

    private void addAndroidHeader(Request.Builder builder) {
        Request.Builder builder2 = builder;
        Request.Builder builder3 = builder;
        builder3.addHeader(EMUI_API_LEVEL_TITLE, PropertyUtil.getSystemProperties("ro.build.version.emui", ""));
        builder3.addHeader(ANDROID_API_LEVEL_TITLE, f.a("").append(Build.VERSION.SDK_INT).toString());
        builder2.addHeader(APP_ID_TITLE, this.appId);
        builder2.addHeader(TERMINAL_TYPE_TITLE, Build.MODEL);
        builder.addHeader(APP_PACKAGE_NAME_TITLE, this.packageName);
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        chain = (RealInterceptorChain)chain;
        Request.Builder builder = chain.request().newBuilder();
        this.addCommomHeader(builder);
        if (TerminalType.ANDROID == this.terminalType) {
            this.addAndroidHeader(builder);
        }
        return chain.proceed(builder.build());
    }
}

