/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wisesecurity.kfs.util;

import com.huawei.wisesecurity.kfs.exception.CodecException;

public final class HexUtil {
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private HexUtil() {
    }

    public static String encodeHexString(byte[] byArray, boolean bl) {
        return new String(HexUtil.encodeHex(byArray, bl));
    }

    public static String encodeHexString(byte[] byArray) {
        return HexUtil.encodeHexString(byArray, false);
    }

    public static byte[] decodeHexString(String string) throws CodecException {
        return HexUtil.decodeHex(string.toCharArray());
    }

    private static char[] encodeHex(byte[] byArray, boolean bl) {
        char[] cArray = bl ? DIGITS_UPPER : DIGITS_LOWER;
        return HexUtil.encodeHex(byArray, cArray);
    }

    private static char[] encodeHex(byte[] byArray, char[] cArray) {
        int n2 = byArray.length;
        char[] cArray2 = new char[n2 << 1];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            cArray2[n3++] = cArray[(byArray[i2] & 0xF0) >>> 4];
            int n4 = n3 + 1;
            cArray2[n3] = cArray[byArray[i2] & 0xF];
            n3 = n4;
        }
        return cArray2;
    }

    private static byte[] decodeHex(char[] cArray) throws CodecException {
        int n2 = cArray.length;
        if ((n2 & 1) == 0) {
            byte[] byArray = new byte[n2 >> 1];
            int n3 = 0;
            int n4 = 0;
            while (n4 < n2) {
                int n5 = Character.digit(cArray[n4], 16);
                if (n5 != -1) {
                    int n6;
                    if ((n6 = Character.digit(cArray[++n4], 16)) != -1) {
                        ++n4;
                        byArray[n3] = (byte)((n5 << 4 | n6) & 0xFF);
                        ++n3;
                        continue;
                    }
                    throw new CodecException("Illegal hexadecimal character at index " + n4);
                }
                throw new CodecException("Illegal hexadecimal character at index " + n4);
            }
            return byArray;
        }
        throw new CodecException("Odd number of characters.");
    }
}

