/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wisesecurity.kfs.util;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.RequiresPermission;
import com.huawei.wisesecurity.kfs.crypto.digest.DigestAlg;
import com.huawei.wisesecurity.kfs.crypto.digest.KfsDigest;
import com.huawei.wisesecurity.kfs.exception.CryptoException;
import com.huawei.wisesecurity.kfs.exception.KfsException;
import com.huawei.wisesecurity.kfs.util.PropertyUtil;
import com.huawei.wisesecurity.ucs_credential.f;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.UUID;

public class KfsDeviceUtil {
    private static final String TAG = "KfsDeviceUtil";
    private static final int MIN_MAGIC_API_LEVEL = 33;
    private static final String PREFERENCES_NAME = "com.huawei.wisesecurity.kfs.DeviceId";
    private static final String UUID_KEY = "UUID";
    public static final int MAGIC_SDK_INT = PropertyUtil.getSystemPropertiesInt("ro.build.magic_api_level", 0);
    public static final int EMUI_SDK_INT = PropertyUtil.getSystemPropertiesInt("ro.build.hw_emui_api_level", 0);
    private static String uuid = "";
    private static String uuidHash = "";

    public static String getAndroidId(Context object) throws KfsException {
        if (Build.VERSION.SDK_INT >= 26) {
            if (!TextUtils.isEmpty((CharSequence)(object = Settings.Secure.getString((ContentResolver)object.getContentResolver(), (String)"android_id").toUpperCase(Locale.US)))) {
                return object;
            }
            throw new KfsException("getAndroidId failed, androidId is null or empty");
        }
        throw new KfsException("Android version not support, min version is Android8(O)");
    }

    /*
     * WARNING - void declaration
     */
    public static String getUDID() throws KfsException {
        void var0_4;
        block7: {
            Method method = KfsDeviceUtil.getBuildExClass().getDeclaredMethod("getUDID", new Class[0]);
            Method method2 = method;
            method.setAccessible(true);
            String string = (String)method2.invoke(null, new Object[0]);
            if (TextUtils.isEmpty((CharSequence)string)) break block7;
            return string;
        }
        try {
            throw new KfsException("getUDID failed, udid is null or empty");
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        throw new KfsException(f.a("getUDID get exception, ").append(var0_4.getMessage()).toString());
    }

    public static String getUUID(Context context) {
        if (!TextUtils.isEmpty((CharSequence)uuid)) {
            return uuid;
        }
        context = (Build.VERSION.SDK_INT >= 24 ? context.createDeviceProtectedStorageContext() : context.getApplicationContext()).getSharedPreferences(PREFERENCES_NAME, 0);
        uuid = context.getString(UUID_KEY, "");
        if (TextUtils.isEmpty((CharSequence)uuid)) {
            uuid = UUID.randomUUID().toString();
            context.edit().putString(UUID_KEY, uuid).apply();
        }
        return uuid;
    }

    public static String getUUIDHash(Context context) throws CryptoException {
        if (TextUtils.isEmpty((CharSequence)uuidHash)) {
            uuidHash = KfsDigest.getDigestHandler(DigestAlg.SHA256).from(KfsDeviceUtil.getUUID(context)).digestHex();
        }
        return uuidHash;
    }

    /*
     * Unable to fully structure code
     */
    private static Class<?> getBuildExClass() throws KfsException {
        block10: {
            var0 = "KfsDeviceUtil";
            var1_2 = new StringBuilder().append("getUDID MAGIC_SDK_INT:");
            var2_3 = KfsDeviceUtil.MAGIC_SDK_INT;
            Log.i((String)var0, (String)var1_2.append(var2_3).toString());
            if (var2_3 < 33) break block10;
            Log.i((String)"KfsDeviceUtil", (String)"clazz name is com.hihonor.android.os.Build");
            v0 = "com.hihonor.android.os.Build";
lbl16:
            // 2 sources

            while (true) {
                var0 = v0;
                ** GOTO lbl28
                break;
            }
        }
        try {
            Log.i((String)"KfsDeviceUtil", (String)"clazz name is com.huawei.android.os.BuildEx");
        }
        catch (ClassNotFoundException var0_1) {
            throw new KfsException(f.a("getBuildExClass get exception").append(var0_1.getMessage()).toString());
        }
        v0 = "com.huawei.android.os.BuildEx";
        ** continue;
lbl28:
        // 1 sources

        return Class.forName(var0);
    }

    @SuppressLint(value={"HardwareIds"})
    public static String getIMEI(Context object) throws KfsException {
        if (!TextUtils.isEmpty((CharSequence)(object = ((TelephonyManager)object.getSystemService("phone")).getDeviceId()))) {
            return object;
        }
        throw new KfsException("getIMEI failed, imei is null or empty");
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    @SuppressLint(value={"HardwareIds", "MissingPermission"})
    public static String getSN(Context context) throws KfsException {
        return KfsDigest.getDigestHandler(DigestAlg.SHA256).from(KfsDeviceUtil.getSerial(context)).digestHex();
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    @SuppressLint(value={"HardwareIds", "MissingPermission"})
    public static String getSerial(Context object) throws KfsException {
        if (Build.VERSION.SDK_INT >= 26) {
            block6: {
                try {
                    if (object.checkSelfPermission("android.permission.READ_PHONE_STATE") != 0) break block6;
                }
                catch (SecurityException securityException) {
                    throw new KfsException(f.a("getSN get exception, ").append(securityException.getMessage()).toString());
                }
                object = Build.getSerial();
            }
            throw new KfsException("getSN failed, read phone state permission not permit");
        }
        object = Build.SERIAL;
        if (!TextUtils.isEmpty((CharSequence)object)) {
            return object;
        }
        throw new KfsException("getSN failed, SN is null or empty");
    }
}

