/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wisesecurity.kfs.validation;

import com.huawei.wisesecurity.kfs.exception.KfsValidationException;
import com.huawei.wisesecurity.kfs.validation.metadata.BeanMetaData;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class KfsValidator {
    private static final String TAG = "KfsValidator";
    private static final Map<Class<?>, BeanMetaData<?>> CACHE_BEAN_META_DATA_MAP = new ConcurrentHashMap();

    private static BeanMetaData<?> getBeanMetaData(Class<?> clazz) throws KfsValidationException {
        BeanMetaData<?> beanMetaData;
        Map<Class<?>, BeanMetaData<?>> map = CACHE_BEAN_META_DATA_MAP;
        if (map.containsKey(clazz)) {
            return map.get(clazz);
        }
        BeanMetaData<?> beanMetaData2 = beanMetaData;
        beanMetaData2(clazz);
        map.put(clazz, beanMetaData2);
        return beanMetaData;
    }

    public static <T> void validate(T t2) throws KfsValidationException {
        if (t2 != null) {
            BeanMetaData<?> beanMetaData = KfsValidator.getBeanMetaData(t2.getClass());
            if (!beanMetaData.hasConstraints()) {
                return;
            }
            beanMetaData.validate(t2);
            return;
        }
        throw new KfsValidationException("validate bean is null");
    }
}

