/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wisesecurity.kfs.validation.constrains.validator;

import com.huawei.wisesecurity.kfs.exception.KfsValidationException;
import com.huawei.wisesecurity.kfs.validation.constrains.KfsLongRange;
import com.huawei.wisesecurity.kfs.validation.constrains.validator.KfsConstraintValidator;

public class KfsLongRangeValidator
implements KfsConstraintValidator<KfsLongRange, Long> {
    private String message;
    private Long min;
    private Long max;
    private String validateTargetName;

    @Override
    public void initialize(String string, KfsLongRange kfsLongRange) throws KfsValidationException {
        this.min = kfsLongRange.min();
        this.max = kfsLongRange.max();
        this.validateTargetName = string;
    }

    @Override
    public boolean isValid(Long l2) {
        if (l2 == null) {
            this.message = this.validateTargetName + " is null";
            return false;
        }
        if (l2 < this.min) {
            this.message = this.validateTargetName + " must >= " + this.min;
            return false;
        }
        if (l2 > this.max) {
            this.message = this.validateTargetName + " must <= " + this.max;
            return false;
        }
        return true;
    }

    @Override
    public String getMessage() {
        return this.message;
    }
}

