/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wisesecurity.kfs.validation.constrains.validator;

import com.huawei.wisesecurity.kfs.exception.KfsValidationException;
import com.huawei.wisesecurity.kfs.validation.constrains.KfsStringRange;
import com.huawei.wisesecurity.kfs.validation.constrains.validator.KfsConstraintValidator;

public class KfsStringRangeValidator
implements KfsConstraintValidator<KfsStringRange, String> {
    private String message;
    private int min;
    private int max;
    private String validateTargetName;

    @Override
    public void initialize(String string, KfsStringRange kfsStringRange) throws KfsValidationException {
        this.min = kfsStringRange.min();
        this.max = kfsStringRange.max();
        this.validateTargetName = string;
    }

    @Override
    public boolean isValid(String string) {
        if (string == null) {
            this.message = this.validateTargetName + " is null";
            return false;
        }
        if (string.length() < this.min) {
            this.message = this.validateTargetName + " length must >= " + this.min;
            return false;
        }
        if (string.length() > this.max) {
            this.message = this.validateTargetName + " length must <= " + this.max;
            return false;
        }
        return true;
    }

    @Override
    public String getMessage() {
        return this.message;
    }
}

