/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wisesecurity.kfs.validation.constrains.validator.size.array;

import com.huawei.wisesecurity.kfs.exception.KfsValidationException;
import com.huawei.wisesecurity.kfs.util.StringUtil;
import com.huawei.wisesecurity.kfs.validation.constrains.KfsSize;
import com.huawei.wisesecurity.kfs.validation.constrains.validator.KfsConstraintValidator;
import com.huawei.wisesecurity.kfs.validation.core.ConstraintParamChecker;

public class KfsSizeValidatorForBooleanArray
implements KfsConstraintValidator<KfsSize, boolean[]> {
    private String message;
    private int min;
    private int max;

    @Override
    public void initialize(String string, KfsSize kfsSize) throws KfsValidationException {
        KfsSize kfsSize2 = kfsSize;
        ConstraintParamChecker.checkSizeParam(kfsSize2);
        this.min = kfsSize2.min();
        this.max = kfsSize.max();
        this.message = StringUtil.replaceIfEmptyForSize(kfsSize, string);
    }

    @Override
    public boolean isValid(boolean[] blArray) {
        if (blArray == null) {
            return true;
        }
        int n2 = blArray.length;
        return n2 >= this.min && n2 <= this.max;
    }

    @Override
    public String getMessage() {
        return this.message;
    }
}

