/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wisesecurity.kfs.validation.core;

import com.huawei.wisesecurity.kfs.validation.constrains.validator.KfsConstraintValidator;
import com.huawei.wisesecurity.kfs.validation.core.TypeHelper;
import com.huawei.wisesecurity.kfs.validation.core.ValidatorDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ValidatorDescriptorImpl<A extends Annotation>
implements ValidatorDescriptor<A> {
    private final Map<Type, Class<? extends KfsConstraintValidator<A, ?>>> validatorDefaultMap;
    private final Map<Type, Class<? extends KfsConstraintValidator<A, ?>>> validatorArrayMap;
    private final Map<Class<?>, Class<?>> primitiveTypeMap;
    private final Map<Class<?>, Class<?>> primitiveArrayClassMap;

    @SafeVarargs
    public ValidatorDescriptorImpl(Class<? extends KfsConstraintValidator<A, ?>> ... classArray) {
        ConcurrentHashMap concurrentHashMap;
        ConcurrentHashMap concurrentHashMap2;
        ConcurrentHashMap concurrentHashMap3;
        ConcurrentHashMap concurrentHashMap4;
        ConcurrentHashMap<Class<?>, Class<?>> concurrentHashMap5 = concurrentHashMap4;
        concurrentHashMap4 = new ConcurrentHashMap();
        this.validatorDefaultMap = concurrentHashMap5;
        concurrentHashMap5 = concurrentHashMap3;
        concurrentHashMap3 = new ConcurrentHashMap();
        this.validatorArrayMap = concurrentHashMap5;
        concurrentHashMap5 = concurrentHashMap2;
        concurrentHashMap2 = new ConcurrentHashMap<Class<?>, Class<?>>(this){
            public final /* synthetic */ ValidatorDescriptorImpl this$0;
            {
                1 v0 = this;
                v0.this$0 = validatorDescriptorImpl;
                v0.put(Byte.TYPE, Byte.class);
                v0.put(Short.TYPE, Short.class);
                v0.put(Integer.TYPE, Integer.class);
                v0.put(Long.TYPE, Long.class);
                v0.put(Float.TYPE, Float.class);
                v0.put(Double.TYPE, Double.class);
                v0.put(Character.TYPE, Character.class);
                v0.put(Boolean.TYPE, Boolean.class);
            }
        };
        this.primitiveTypeMap = concurrentHashMap5;
        concurrentHashMap5 = concurrentHashMap;
        concurrentHashMap = new ConcurrentHashMap<Class<?>, Class<?>>(this){
            public final /* synthetic */ ValidatorDescriptorImpl this$0;
            {
                2 v0 = this;
                v0.this$0 = validatorDescriptorImpl;
                v0.put(Byte.TYPE, byte[].class);
                v0.put(Short.TYPE, short[].class);
                v0.put(Integer.TYPE, int[].class);
                v0.put(Long.TYPE, long[].class);
                v0.put(Float.TYPE, float[].class);
                v0.put(Double.TYPE, double[].class);
                v0.put(Character.TYPE, char[].class);
                v0.put(Boolean.TYPE, boolean[].class);
            }
        };
        this.primitiveArrayClassMap = concurrentHashMap5;
        int n2 = classArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.putConstraint(classArray[i2]);
        }
    }

    private void putConstraint(Class<? extends KfsConstraintValidator<A, ?>> clazz) {
        Type type = TypeHelper.extractValidatorType(clazz);
        if (type instanceof Class) {
            Class clazz2 = (Class)type;
            if (clazz2.isArray()) {
                this.validatorArrayMap.put(clazz2.getComponentType(), clazz);
            }
            this.validatorDefaultMap.put(type, clazz);
        } else if (type instanceof GenericArrayType && this.primitiveArrayClassMap.containsKey(type = (Class)((GenericArrayType)type).getGenericComponentType())) {
            this.validatorDefaultMap.put(this.primitiveArrayClassMap.get(type), clazz);
        }
    }

    private Class<? extends KfsConstraintValidator<A, ?>> getValidatorForClassAndHierarchy(Map<Type, Class<? extends KfsConstraintValidator<A, ?>>> map, Class<?> typeArray) {
        if (map.containsKey(typeArray)) {
            return map.get(typeArray);
        }
        Class<KfsConstraintValidator<A, ?>> clazz = this.getValidatorType(map, typeArray.getGenericSuperclass());
        if (clazz != null) {
            return clazz;
        }
        typeArray = typeArray.getGenericInterfaces();
        int n2 = typeArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Class<KfsConstraintValidator<A, ?>> clazz2 = this.getValidatorType(map, typeArray[i2]);
            if (clazz2 == null) continue;
            return clazz2;
        }
        return null;
    }

    private Class<? extends KfsConstraintValidator<A, ?>> getValidatorType(Map<Type, Class<? extends KfsConstraintValidator<A, ?>>> map, Type type) {
        Class<KfsConstraintValidator<A, ?>> clazz;
        if (type == null) {
            return null;
        }
        if (type instanceof Class && (clazz = this.getValidatorForClassAndHierarchy(map, (Class)type)) != null) {
            return clazz;
        }
        if (type instanceof ParameterizedType) {
            if (!((type = (ParameterizedType)type).getRawType() instanceof Class)) {
                return null;
            }
            return this.getValidatorForClassAndHierarchy(map, (Class)type.getRawType());
        }
        return null;
    }

    private Class<?> normalizeClass(Class<?> clazz) {
        if (this.primitiveTypeMap.containsKey(clazz)) {
            return this.primitiveTypeMap.get(clazz);
        }
        return clazz;
    }

    @Override
    public Class<? extends KfsConstraintValidator<A, ?>> getValidator(Class<?> clazz) {
        Class<KfsConstraintValidator<A, ?>> clazz2;
        if (clazz == null) {
            return null;
        }
        ValidatorDescriptorImpl validatorDescriptorImpl = this;
        clazz = validatorDescriptorImpl.normalizeClass(clazz);
        if (validatorDescriptorImpl.validatorDefaultMap.containsKey(Object.class)) {
            return this.validatorDefaultMap.get(Object.class);
        }
        if (this.validatorDefaultMap.containsKey(clazz)) {
            return this.validatorDefaultMap.get(clazz);
        }
        if (clazz.isArray()) {
            clazz2 = this.validatorArrayMap;
            clazz2 = this.getValidatorType((Map<Type, Class<? extends KfsConstraintValidator<A, ?>>>)((Object)clazz2), clazz.getComponentType());
        } else {
            ValidatorDescriptorImpl validatorDescriptorImpl2 = this;
            clazz2 = validatorDescriptorImpl2.getValidatorType(validatorDescriptorImpl2.validatorDefaultMap, clazz);
        }
        if (clazz2 != null) {
            this.validatorDefaultMap.put(clazz, clazz2);
        }
        return clazz2;
    }
}

