/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wisesecurity.kfs.validation.metadata;

import com.huawei.wisesecurity.kfs.exception.KfsValidationException;
import com.huawei.wisesecurity.kfs.validation.constrains.KfsConstraint;
import com.huawei.wisesecurity.kfs.validation.constrains.KfsValid;
import com.huawei.wisesecurity.kfs.validation.metadata.BeanMetaData;
import com.huawei.wisesecurity.kfs.validation.metadata.ConstraintMetaData;
import com.huawei.wisesecurity.ucs_credential.f;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FieldMetaData {
    private final String beanName;
    private final Field field;
    private final List<ConstraintMetaData> constraintMetaDataList;
    private BeanMetaData validKfsMetaData;

    public FieldMetaData(String string, Field field) throws KfsValidationException {
        Annotation[] annotationArray;
        Field field2 = field;
        Annotation[] annotationArray2 = annotationArray;
        annotationArray = new ArrayList();
        this.constraintMetaDataList = annotationArray2;
        this.beanName = string;
        this.field = field;
        field2.setAccessible(true);
        for (Annotation annotation : field2.getDeclaredAnnotations()) {
            BeanMetaData beanMetaData;
            if (annotation.annotationType().getAnnotation(KfsConstraint.class) == null) continue;
            if (annotation.annotationType() != KfsValid.class) {
                String string2 = this.getFieldName();
                Class<?> clazz = field.getType();
                this.constraintMetaDataList.add(new ConstraintMetaData(string2, annotation, clazz));
                continue;
            }
            BeanMetaData beanMetaData2 = beanMetaData;
            beanMetaData = new BeanMetaData(string, field.getType());
            this.validKfsMetaData = beanMetaData2;
        }
    }

    private String getFieldName() {
        return this.beanName + "." + this.field.getName();
    }

    public boolean hasConstraints() {
        return this.constraintMetaDataList.size() > 0 || this.validKfsMetaData != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> void validate(T object) throws KfsValidationException {
        try {
            FieldMetaData fieldMetaData = beanMetaData;
            object = fieldMetaData.field.get(object);
            Iterator<ConstraintMetaData> iterator = fieldMetaData.constraintMetaDataList.iterator();
            while (iterator.hasNext()) {
                iterator.next().validate(object);
            }
            BeanMetaData beanMetaData = ((FieldMetaData)((Object)beanMetaData)).validKfsMetaData;
            if (beanMetaData != null) {
                beanMetaData.validate(object);
            }
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new KfsValidationException(f.a("field validate failed:").append(illegalAccessException.getMessage()).toString());
        }
    }
}

