/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wisesecurity.ucs.credential;

import android.content.Context;
import com.huawei.wisesecurity.kfs.crypto.codec.Decoder;
import com.huawei.wisesecurity.kfs.exception.CodecException;
import com.huawei.wisesecurity.kfs.exception.KfsValidationException;
import com.huawei.wisesecurity.kfs.validation.KfsValidator;
import com.huawei.wisesecurity.kfs.validation.constrains.KfsLongRange;
import com.huawei.wisesecurity.kfs.validation.constrains.KfsStringNotEmpty;
import com.huawei.wisesecurity.ucs.common.exception.UcsException;
import com.huawei.wisesecurity.ucs.common.exception.UcsParamException;
import com.huawei.wisesecurity.ucs.common.log.LogUcs;
import com.huawei.wisesecurity.ucs.credential.entity.AccessKey;
import com.huawei.wisesecurity.ucs.credential.entity.KeyEncryptKey;
import com.huawei.wisesecurity.ucs.credential.nativelib.UcsLib;
import com.huawei.wisesecurity.ucs_credential.e;
import com.huawei.wisesecurity.ucs_credential.f;
import com.huawei.wisesecurity.ucs_credential.h;
import com.huawei.wisesecurity.ucs_credential.i;
import com.huawei.wisesecurity.ucs_credential.l;
import org.json.JSONException;

public class Credential {
    private static final String TAG = "Credential";
    private static final String SK = "secretKey";
    private static final String AK = "accessKey";
    private static final String DK = "dataKey";
    private static final String KEK = "kek";
    private static final String EXPIRE_TIME = "expireTime";
    private static final byte[] EMPTY_BYTES = new byte[0];
    @KfsStringNotEmpty
    private String secretKey;
    @KfsStringNotEmpty
    private String dataKey;
    @KfsStringNotEmpty
    private String accessKey;
    @KfsStringNotEmpty
    private String rawKek;
    @KfsLongRange(max=0x7FFFFFFFFFFFFFFFL, min=1L)
    private long expireTime;
    private KeyEncryptKey kek;
    private AccessKey ak;

    private Credential() {
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static Credential fromString(Context var0, String var1_4, i var2_10) throws UcsException {
        var3_11 = v0;
        v1 = var2_10;
        v2 = var3_11;
        v3 = var2_10;
        v4 = var3_11;
        v5 = var2_10;
        v6 = var3_11;
        v7 = v6;
        v8 = v6;
        v9 = v6;
        v10 = v6;
        v11 = v6;
        v12 /* !! */  = var0 /* !! */ ;
        v13 = var3_11;
        v14 = v13;
        v15 = v13;
        v13();
        var2_10 = v16;
        v17 = var2_10;
        v17(var1_4);
        var3_11.secretKey = v17.optString("secretKey");
        var3_11.dataKey = var2_10.optString("dataKey");
        var3_11.accessKey = var2_10.optString("accessKey");
        var3_11.rawKek = var2_10.optString("kek");
        v15.expireTime = v16.optLong("expireTime");
        v8.kek = KeyEncryptKey.fromString(v12 /* !! */ , v14.rawKek);
        v9.checkParam();
        v11.ak = AccessKey.fromString(v10.accessKey);
        var1_4 = v7.getAppPkgName();
        v5.linkedHashMap.put("credentialAppName", var1_4);
        var1_5 = v4.getAkskVersion();
        v3.linkedHashMap.put("akSkVersion", String.valueOf(var1_5));
        var1_6 = Credential.getCty(v2.getKekVersion());
        v1.linkedHashMap.put("cty", (String)var1_6);
        if (!v0.ak.hasAkskVersion()) ** GOTO lbl60
        v18 /* !! */  = var0 /* !! */ ;
        v19 = var3_11;
        UcsLib.checkNativeLibrary();
        var1_6 = v20;
        v20 = new StringBuilder();
        if (UcsLib.checkPkgNameCertFP(v18 /* !! */ , v19.ak.getAppPkgName(), var3_11.ak.getAppCertFP(), (StringBuilder)var1_6)) ** GOTO lbl60
        var0 /* !! */  = "check AppPkgName appCertFP fail " + var1_6.toString();
        try {
            LogUcs.e((String)"Credential", (String)var0 /* !! */ , (Object[])new Object[0]);
            throw new UcsException(1023L, (String)var0 /* !! */ );
lbl60:
            // 2 sources

            v21 = var3_11;
            l.b(v21).b(var3_11, var0 /* !! */ );
            return v21;
        }
        catch (Exception v22) {
            var0 /* !! */  = e.a(v22, f.a("parse credentialStr get exception : "));
            var1_7 = new Object[]{};
            throw h.a("Credential", (String)var0 /* !! */ , var1_7, 2001L, (String)var0 /* !! */ );
        }
        catch (UcsException var0_1) {
            v23 = new Object[2];
            var1_8 = v23;
            var1_8[0] = var0_1.getErrorCode();
            v23[1] = var0_1.getMessage();
            LogUcs.e((String)"Credential", (String)"parse credentialStr get UCS exception : errorCode : {0} errorMsg : {1}", (Object[])var1_8);
            throw var0_1;
        }
        catch (JSONException var0_2) {
            v24 = new Object[1];
            var1_9 = v24;
            v24[0] = var0_2.getMessage();
            LogUcs.e((String)"Credential", (String)"parse credentialStr get json exception : {0}", (Object[])var1_9);
            var0_3 = f.a("parse credentialStr get json exception : ").append(var0_2.getMessage()).toString();
            throw new UcsException(1002L, var0_3);
        }
    }

    private byte[] base64DecodeForNative(String string) {
        try {
            return Decoder.BASE64.decode(string);
        }
        catch (CodecException codecException) {
            return EMPTY_BYTES;
        }
    }

    private static String getCty(int n2) {
        if (n2 != 0) {
            if (n2 != 3) {
                if (n2 != 6) {
                    if (n2 != 7) {
                        return "";
                    }
                    return "Huks_EC";
                }
                return "AndroidKS_EC";
            }
            return "AndroidKS";
        }
        return "Kid";
    }

    public String getKekString() {
        return this.kek.getKey();
    }

    public String toString() {
        Object object;
        Object[] objectArray;
        Object[] objectArray2 = objectArray;
        Credential credential = object;
        Credential credential2 = object;
        Credential credential3 = object;
        Credential credential4 = object;
        Credential credential5 = object;
        objectArray2();
        try {
            object = SK;
        }
        catch (JSONException jSONException) {
            Object[] objectArray3 = new Object[1];
            objectArray2 = objectArray3;
            objectArray3[0] = jSONException.getMessage();
            LogUcs.e((String)TAG, (String)"Credential toString exception : {0}", (Object[])objectArray2);
            return "";
        }
        objectArray2.put((String)object, (Object)credential5.secretKey);
        object = AK;
        objectArray2.put((String)object, (Object)credential4.accessKey);
        object = DK;
        objectArray2.put((String)object, (Object)credential3.dataKey);
        object = KEK;
        objectArray2.put((String)object, (Object)credential2.rawKek);
        object = EXPIRE_TIME;
        long l2 = credential.expireTime;
        objectArray.put((String)object, l2);
        return objectArray.toString();
    }

    public void checkParam() throws UcsException {
        try {
            KfsValidator.validate(this);
            return;
        }
        catch (KfsValidationException kfsValidationException) {
            throw new UcsParamException(f.a("credential get param exception : ").append(kfsValidationException.getMessage()).toString());
        }
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getDataKey() {
        return this.dataKey;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getRawKek() {
        return this.rawKek;
    }

    public long getExpireTime() {
        return this.expireTime;
    }

    public int getAkskVersion() {
        return this.ak.getAkskVersion();
    }

    public String getAppPkgName() {
        return this.ak.getAppPkgName();
    }

    public String getAppCertFP() {
        return this.ak.getAppCertFP();
    }

    public int getKekVersion() {
        return this.kek.getVersion();
    }

    public byte[] getSecretKeyBytes() {
        Credential credential = this;
        return credential.base64DecodeForNative(credential.secretKey);
    }

    public byte[] getDataKeyBytes() {
        Credential credential = this;
        return credential.base64DecodeForNative(credential.dataKey);
    }

    public byte[] getKekBytes() {
        Credential credential = this;
        return credential.base64DecodeForNative(credential.kek.getKey());
    }

    public int getAlg() {
        return this.kek.getAlg();
    }

    public int getKekAlg() {
        return this.kek.getKekAlg();
    }
}

