/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wisesecurity.ucs.credential.crypto.cipher;

import com.huawei.wisesecurity.kfs.crypto.cipher.KfsCipher;
import com.huawei.wisesecurity.kfs.exception.KfsValidationException;
import com.huawei.wisesecurity.kfs.util.ByteUtil;
import com.huawei.wisesecurity.kfs.validation.KfsValidator;
import com.huawei.wisesecurity.kfs.validation.constrains.KfsNotNull;
import com.huawei.wisesecurity.ucs.common.exception.UcsException;
import com.huawei.wisesecurity.ucs.common.exception.UcsParamException;
import com.huawei.wisesecurity.ucs.credential.Credential;
import com.huawei.wisesecurity.ucs.credential.CredentialClient;
import com.huawei.wisesecurity.ucs.credential.crypto.cipher.CredentialCipherAlg;
import com.huawei.wisesecurity.ucs.credential.crypto.cipher.CredentialCipherText;
import com.huawei.wisesecurity.ucs.credential.crypto.cipher.CredentialDecryptHandler;
import com.huawei.wisesecurity.ucs.credential.crypto.cipher.CredentialEncryptHandler;
import com.huawei.wisesecurity.ucs_credential.f;

public class CredentialCipher
implements KfsCipher {
    private Credential credential;
    public CredentialCipherText cipherText;
    private CredentialClient credentialClient;

    public CredentialCipher(CredentialCipherAlg credentialCipherAlg, Credential credential, byte[] byArray, CredentialClient credentialClient) {
        CredentialCipherText credentialCipherText;
        ((CredentialCipher)((Object)credentialCipherText2)).credential = credential;
        CredentialCipherText credentialCipherText2 = credentialCipherText;
        new CredentialCipherText().setAlgId(credentialCipherAlg);
        credentialCipherText2.setIv(byArray);
        v1.cipherText = credentialCipherText2;
        v1.credentialClient = credentialClient;
    }

    @Override
    public CredentialEncryptHandler getEncryptHandler() {
        CredentialCipher credentialCipher = credential;
        Credential credential = credentialCipher.credential;
        CredentialCipherText credentialCipherText = credentialCipher.cipherText;
        CredentialClient credentialClient = credentialCipher.credentialClient;
        return new CredentialEncryptHandler(credential, credentialCipherText, credentialClient);
    }

    @Override
    public CredentialDecryptHandler getDecryptHandler() {
        CredentialCipher credentialCipher = credential;
        Credential credential = credentialCipher.credential;
        CredentialCipherText credentialCipherText = credentialCipher.cipherText;
        CredentialClient credentialClient = credentialCipher.credentialClient;
        return new CredentialDecryptHandler(credential, credentialCipherText, credentialClient);
    }

    public static class Builder {
        @KfsNotNull
        private CredentialCipherAlg cipherAlg = CredentialCipherAlg.AES_GCM;
        @KfsNotNull
        private Credential credential;
        @KfsNotNull
        private byte[] iv;
        @KfsNotNull
        private CredentialClient credentialClient;

        public Builder withAlg(CredentialCipherAlg credentialCipherAlg) {
            this.cipherAlg = credentialCipherAlg;
            return this;
        }

        public Builder withCredential(Credential credential) {
            this.credential = credential;
            return this;
        }

        public Builder withIv(byte[] byArray) {
            this.iv = ByteUtil.clone(byArray);
            return this;
        }

        public Builder withCredentialClient(CredentialClient credentialClient) {
            this.credentialClient = credentialClient;
            return this;
        }

        public CredentialCipher build() throws UcsException {
            Builder builder;
            Builder builder2;
            Builder builder3;
            CredentialCipher credentialCipher;
            CredentialCipher credentialCipher2;
            try {
                CredentialCipher credentialCipher3;
                KfsValidator.validate(object);
                credentialCipher2 = credentialCipher3;
                credentialCipher = credentialCipher3;
                Builder builder4 = object;
                builder3 = builder4;
                builder2 = builder4;
                builder = builder4;
                Object object = builder4.cipherAlg;
            }
            catch (KfsValidationException kfsValidationException) {
                throw new UcsParamException(f.a("CredentialCipher check param error : ").append(kfsValidationException.getMessage()).toString());
            }
            Credential credential = builder3.credential;
            byte[] byArray = builder2.iv;
            CredentialClient credentialClient = builder.credentialClient;
            credentialCipher2((CredentialCipherAlg)((Object)object), credential, byArray, credentialClient);
            return credentialCipher;
        }
    }
}

