/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wisesecurity.ucs.credential.crypto.signer;

import com.huawei.wisesecurity.kfs.crypto.signer.KfsSigner;
import com.huawei.wisesecurity.kfs.exception.KfsValidationException;
import com.huawei.wisesecurity.kfs.validation.KfsValidator;
import com.huawei.wisesecurity.kfs.validation.constrains.KfsNotNull;
import com.huawei.wisesecurity.ucs.common.exception.UcsException;
import com.huawei.wisesecurity.ucs.common.exception.UcsParamException;
import com.huawei.wisesecurity.ucs.credential.Credential;
import com.huawei.wisesecurity.ucs.credential.CredentialClient;
import com.huawei.wisesecurity.ucs.credential.crypto.signer.CredentialSignAlg;
import com.huawei.wisesecurity.ucs.credential.crypto.signer.CredentialSignHandler;
import com.huawei.wisesecurity.ucs.credential.crypto.signer.CredentialSignText;
import com.huawei.wisesecurity.ucs.credential.crypto.signer.CredentialVerifyHandler;
import com.huawei.wisesecurity.ucs_credential.f;

public class CredentialSigner
implements KfsSigner {
    private CredentialSignText signText;
    private Credential credential;
    private CredentialClient credentialClient;

    private CredentialSigner(CredentialSignAlg credentialSignAlg, Credential object, CredentialClient credentialClient) {
        CredentialSignText credentialSignText;
        this.credential = object;
        object = credentialSignText;
        ((CredentialSignText)object)();
        this.signText = object;
        credentialSignText.setAlgId(credentialSignAlg);
        this.credentialClient = credentialClient;
    }

    public /* synthetic */ CredentialSigner(CredentialSignAlg credentialSignAlg, Credential credential, CredentialClient credentialClient, 1 var4_4) {
        this(credentialSignAlg, credential, credentialClient);
    }

    @Override
    public CredentialSignHandler getSignHandler() {
        CredentialSigner credentialSigner = credential;
        Credential credential = credentialSigner.credential;
        CredentialSignText credentialSignText = credentialSigner.signText;
        CredentialClient credentialClient = credentialSigner.credentialClient;
        return new CredentialSignHandler(credential, credentialSignText, credentialClient);
    }

    @Override
    public CredentialVerifyHandler getVerifyHandler() {
        CredentialSigner credentialSigner = credential;
        Credential credential = credentialSigner.credential;
        CredentialSignText credentialSignText = credentialSigner.signText;
        CredentialClient credentialClient = credentialSigner.credentialClient;
        return new CredentialVerifyHandler(credential, credentialSignText, credentialClient);
    }

    public static class Builder {
        @KfsNotNull
        private CredentialSignAlg signAlg = CredentialSignAlg.HMAC_SHA256;
        @KfsNotNull
        private Credential credential;
        @KfsNotNull
        private CredentialClient credentialClient;

        public Builder withAlg(CredentialSignAlg credentialSignAlg) {
            this.signAlg = credentialSignAlg;
            return this;
        }

        public Builder withCredential(Credential credential) {
            this.credential = credential;
            return this;
        }

        public Builder withCredentialClient(CredentialClient credentialClient) {
            this.credentialClient = credentialClient;
            return this;
        }

        public CredentialSigner build() throws UcsException {
            Builder builder;
            Builder builder2;
            CredentialSigner credentialSigner;
            CredentialSigner credentialSigner2;
            try {
                CredentialSigner credentialSigner3;
                KfsValidator.validate(object);
                credentialSigner2 = credentialSigner3;
                credentialSigner = credentialSigner3;
                Builder builder3 = object;
                builder2 = builder3;
                builder = builder3;
                Object object = builder3.signAlg;
            }
            catch (KfsValidationException kfsValidationException) {
                throw new UcsParamException(f.a("CredentialCipher check param error : ").append(kfsValidationException.getMessage()).toString());
            }
            Credential credential = builder.credential;
            CredentialClient credentialClient = builder2.credentialClient;
            credentialSigner2((CredentialSignAlg)((Object)object), credential, credentialClient, null);
            return credentialSigner;
        }
    }
}

