/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wisesecurity.ucs.credential.crypto.signer;

import android.text.TextUtils;
import com.huawei.wisesecurity.kfs.crypto.codec.Decoder;
import com.huawei.wisesecurity.kfs.crypto.signer.SignAlg;
import com.huawei.wisesecurity.kfs.crypto.signer.VerifyHandler;
import com.huawei.wisesecurity.kfs.crypto.signer.hmac.HmacSigner;
import com.huawei.wisesecurity.kfs.exception.CodecException;
import com.huawei.wisesecurity.kfs.exception.CryptoException;
import com.huawei.wisesecurity.ucs.common.exception.UcsCryptoException;
import com.huawei.wisesecurity.ucs.common.exception.UcsException;
import com.huawei.wisesecurity.ucs.common.exception.UcsParamException;
import com.huawei.wisesecurity.ucs.credential.Credential;
import com.huawei.wisesecurity.ucs.credential.CredentialClient;
import com.huawei.wisesecurity.ucs.credential.crypto.signer.CredentialSignText;
import com.huawei.wisesecurity.ucs.credential.entity.SkDkEntity;
import com.huawei.wisesecurity.ucs_credential.f;
import com.huawei.wisesecurity.ucs_credential.l;
import com.huawei.wisesecurity.ucs_credential.o;
import java.nio.charset.StandardCharsets;

public class CredentialVerifyHandler
implements VerifyHandler {
    private Credential credential;
    private CredentialSignText signText;
    private CredentialClient credentialClient;

    public CredentialVerifyHandler(Credential credential, CredentialSignText credentialSignText, CredentialClient credentialClient) {
        this.credential = credential;
        this.signText = credentialSignText;
        this.credentialClient = credentialClient;
    }

    private CredentialVerifyHandler fromData(String string, Decoder decoder) throws UcsCryptoException {
        CredentialVerifyHandler credentialVerifyHandler;
        try {
            CredentialVerifyHandler credentialVerifyHandler2 = this;
            credentialVerifyHandler = credentialVerifyHandler2;
            credentialVerifyHandler2.fromData(decoder.decode(string));
        }
        catch (CodecException codecException) {
            String string2 = f.a("Fail to decode sign data: ").append(codecException.getMessage()).toString();
            throw new UcsCryptoException(1003L, string2);
        }
        return credentialVerifyHandler;
    }

    private boolean verify(String string, Decoder decoder) throws UcsCryptoException {
        try {
            return this.verify(decoder.decode(string));
        }
        catch (CodecException codecException) {
            String string2 = f.a("Fail to decode signature : ").append(codecException.getMessage()).toString();
            throw new UcsCryptoException(1003L, string2);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doVerify() throws UcsCryptoException {
        v0 = this;
        var1_1 = (o)new o().a().setApiName("appAuth.verify").setCallTime();
        v0.signText.checkParam(false);
        var2_2 = l.a(v0.credential);
        var2_2 = SkDkEntity.from(v0.credential.getSecretKeyBytes()).decryptSkDk(var2_2);
        v1 = v0.checkSignature(new HmacSigner.Builder().withKey(var2_2).withAlg(SignAlg.HMAC_SHA256).build().getSignHandler().from(this.signText.getDataBytes()).sign(), this.signText.getSignature());
        v2 = this;
        var1_1.setStatusCode(0);
        v2.credentialClient.reportLogs(var1_1);
        return v1;
        {
            catch (Throwable v3) {
            }
            catch (CryptoException var2_3) {
                ** GOTO lbl-1000
            }
            catch (UcsException var2_4) {
                // empty catch block
            }
lbl-1000:
            // 2 sources

            {
                var2_5 = "Fail to verify, errorMessage : " + var2_5.getMessage();
                var1_1.setStatusCode(1003).setErrorMsg(var2_5);
            }
            {
                throw new UcsCryptoException(1003L, var2_5);
                catch (UcsParamException var2_6) {}
                var2_7 = "Fail to verify, errorMessage : " + var2_6.getMessage();
                var1_1.setStatusCode(1001).setErrorMsg(var2_7);
            }
            {
                throw new UcsCryptoException(1001L, var2_7);
            }
        }
        this.credentialClient.reportLogs(var1_1);
        throw v3;
    }

    private boolean checkSignature(byte[] byArray, byte[] byArray2) {
        if (byArray != null && byArray2 != null && byArray.length == byArray2.length) {
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                if (byArray[i2] == byArray2[i2]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public CredentialVerifyHandler fromData(byte[] byArray) {
        CredentialVerifyHandler credentialVerifyHandler = this;
        credentialVerifyHandler.signText.setDataBytes(byArray);
        return credentialVerifyHandler;
    }

    @Override
    public CredentialVerifyHandler fromData(String string) throws UcsCryptoException {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return this.fromData(string.getBytes(StandardCharsets.UTF_8));
        }
        throw new UcsCryptoException(1001L, "dataString cannot empty..");
    }

    @Override
    public CredentialVerifyHandler fromBase64Data(String string) throws UcsCryptoException {
        return this.fromData(string, Decoder.BASE64);
    }

    @Override
    public CredentialVerifyHandler fromBase64UrlData(String string) throws UcsCryptoException {
        return this.fromData(string, Decoder.BASE64URL);
    }

    @Override
    public CredentialVerifyHandler fromHexData(String string) throws UcsCryptoException {
        return this.fromData(string, Decoder.HEX);
    }

    @Override
    public boolean verify(byte[] byArray) throws UcsCryptoException {
        CredentialVerifyHandler credentialVerifyHandler = this;
        credentialVerifyHandler.signText.setSignature(byArray);
        return credentialVerifyHandler.doVerify();
    }

    @Override
    public boolean verify(String string) throws UcsCryptoException {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return this.verify(string.getBytes(StandardCharsets.UTF_8));
        }
        throw new UcsCryptoException(1001L, "signature cannot empty..");
    }

    @Override
    public boolean verifyBase64(String string) throws UcsCryptoException {
        return this.verify(string, Decoder.BASE64);
    }

    @Override
    public boolean verifyBase64Url(String string) throws UcsCryptoException {
        return this.verify(string, Decoder.BASE64URL);
    }

    @Override
    public boolean verifyHex(String string) throws UcsCryptoException {
        return this.verify(string, Decoder.HEX);
    }
}

