/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wisesecurity.ucs.credential.entity;

import com.huawei.wisesecurity.kfs.exception.KfsValidationException;
import com.huawei.wisesecurity.kfs.validation.KfsValidator;
import com.huawei.wisesecurity.kfs.validation.constrains.KfsStringNotEmpty;
import com.huawei.wisesecurity.ucs.common.exception.UcsException;
import com.huawei.wisesecurity.ucs.common.utils.StringUtil;
import com.huawei.wisesecurity.ucs_credential.f;
import org.json.JSONException;
import org.json.JSONObject;

public class AccessKey {
    private static final String AKSK_VERSION = "akskVersion";
    private static final String APP_PKG_NAME = "appPkgName";
    private static final String APP_CERT_FP = "appCertFP";
    private int akskVersion;
    @KfsStringNotEmpty
    private String appCertFP;
    @KfsStringNotEmpty
    private String appPkgName;

    public static AccessKey fromString(String string) throws UcsException {
        AccessKey accessKey;
        block6: {
            JSONObject jSONObject;
            AccessKey accessKey2;
            accessKey = accessKey2;
            accessKey2 = new AccessKey();
            JSONObject jSONObject2 = jSONObject;
            JSONObject jSONObject3 = jSONObject2;
            jSONObject3(StringUtil.base64DecodeToString((String)string, (int)0));
            accessKey.akskVersion = jSONObject3.optInt(AKSK_VERSION);
            accessKey.appPkgName = jSONObject2.optString(APP_PKG_NAME);
            accessKey2.appCertFP = jSONObject.optString(APP_CERT_FP);
            if (!accessKey2.hasAkskVersion()) break block6;
            try {
                KfsValidator.validate(accessKey);
            }
            catch (KfsValidationException kfsValidationException) {
                String string2 = f.a("accessKey param invalid : ").append(kfsValidationException.getMessage()).toString();
                throw new UcsException(1001L, string2);
            }
            catch (JSONException jSONException) {
                String string3 = f.a("accessKey param is not a valid json string : ").append(jSONException.getMessage()).toString();
                throw new UcsException(1001L, string3);
            }
        }
        return accessKey;
    }

    public String getAppCertFP() {
        return this.appCertFP;
    }

    public String getAppPkgName() {
        return this.appPkgName;
    }

    public int getAkskVersion() {
        return this.akskVersion;
    }

    public boolean hasAkskVersion() {
        return this.akskVersion >= 1;
    }
}

