/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wisesecurity.ucs.credential.entity;

import android.content.Context;
import com.huawei.wisesecurity.kfs.exception.KfsValidationException;
import com.huawei.wisesecurity.kfs.validation.KfsValidator;
import com.huawei.wisesecurity.kfs.validation.constrains.KfsIntegerRange;
import com.huawei.wisesecurity.kfs.validation.constrains.KfsStringNotEmpty;
import com.huawei.wisesecurity.ucs.common.exception.UcsException;
import com.huawei.wisesecurity.ucs.common.utils.SpUtil;
import com.huawei.wisesecurity.ucs.common.utils.StringUtil;
import com.huawei.wisesecurity.ucs.credential.nativelib.UcsLib;
import com.huawei.wisesecurity.ucs_credential.f;
import com.huawei.wisesecurity.ucs_credential.g0;
import com.huawei.wisesecurity.ucs_credential.w;
import org.json.JSONException;
import org.json.JSONObject;

public class KeyEncryptKey {
    private static final String TAG = "KeyEncryptKey";
    private static final int KEK_ALG_GCM = 1;
    private int version;
    private int v1;
    private int v2;
    @KfsIntegerRange(max=5, min=0)
    private int alg;
    @KfsIntegerRange(max=1, min=0)
    private int kekAlg;
    @KfsStringNotEmpty
    private String key;

    public static KeyEncryptKey fromString(Context context, String string) throws UcsException {
        block7: {
            JSONObject jSONObject;
            KeyEncryptKey keyEncryptKey;
            KeyEncryptKey keyEncryptKey2 = keyEncryptKey;
            Context context2 = context;
            KeyEncryptKey keyEncryptKey3 = keyEncryptKey2;
            KeyEncryptKey keyEncryptKey4 = keyEncryptKey3;
            KeyEncryptKey keyEncryptKey5 = keyEncryptKey3;
            KeyEncryptKey keyEncryptKey6 = keyEncryptKey3;
            keyEncryptKey3();
            context = jSONObject;
            Context context3 = context;
            context3(StringUtil.base64DecodeToString((String)string, (int)0));
            keyEncryptKey2.version = context3.getInt("version");
            keyEncryptKey2.alg = context.getInt("alg");
            keyEncryptKey2.kekAlg = context.getInt("kekAlg");
            keyEncryptKey2.key = context.getString("key");
            keyEncryptKey2.v1 = context.optInt("v1");
            keyEncryptKey4.v2 = jSONObject.optInt("v2");
            KfsValidator.validate(keyEncryptKey5);
            keyEncryptKey.checkVersion(context2, keyEncryptKey6.version);
            if (keyEncryptKey.kekAlg != 1) break block7;
            return keyEncryptKey2;
        }
        try {
            throw new UcsException(1020L, "unsupported kek alg");
        }
        catch (KfsValidationException kfsValidationException) {
            String string2 = f.a("kek param invalid : ").append(kfsValidationException.getMessage()).toString();
            throw new UcsException(1001L, string2);
        }
        catch (JSONException jSONException) {
            String string3 = f.a("kek param is not a valid json string : ").append(jSONException.getMessage()).toString();
            throw new UcsException(1001L, string3);
        }
    }

    private void checkVersion(Context context, int n2) throws UcsException {
        UcsLib.checkNativeLibrary();
        if (n2 == 3) {
            return;
        }
        if (n2 == 6) {
            return;
        }
        if (n2 == 7) {
            return;
        }
        KeyEncryptKey keyEncryptKey = this;
        keyEncryptKey.checkSoVersion();
        keyEncryptKey.checkC1Version(context);
        keyEncryptKey.updateRootKey(context);
    }

    private void checkC1Version(Context context) throws UcsException {
        int n2 = SpUtil.getInt((String)"Local-C1-Version", (int)-1, (Context)context);
        if (this.v2 == n2) {
            return;
        }
        throw new UcsException(1020L, "kek V2 with C1 version check fail,  please reapply the credential.");
    }

    private void updateRootKey(Context context) throws UcsException {
        if (UcsLib.isRootKeyUpdated()) {
            return;
        }
        w.a(context, new g0());
    }

    private void checkSoVersion() throws UcsException {
        int n2 = (int)UcsLib.ucsGetSoVersion();
        if (this.v1 == n2) {
            return;
        }
        throw new UcsException(1020L, "kek V1 with so version check fail,  please reapply the credential.");
    }

    public int getVersion() {
        return this.version;
    }

    public int getV1() {
        return this.v1;
    }

    public int getV2() {
        return this.v2;
    }

    public int getAlg() {
        return this.alg;
    }

    public int getKekAlg() {
        return this.kekAlg;
    }

    public String getKey() {
        return this.key;
    }
}

