/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wisesecurity.ucs.credential.entity;

import com.huawei.wisesecurity.kfs.crypto.cipher.CipherAlg;
import com.huawei.wisesecurity.kfs.crypto.cipher.aes.AESCipher;
import com.huawei.wisesecurity.kfs.exception.CryptoException;
import com.huawei.wisesecurity.ucs.common.exception.UcsException;
import com.huawei.wisesecurity.ucs_credential.f;
import javax.crypto.spec.SecretKeySpec;

public class SkDkEntity {
    private static final int GCM_IV_LEN = 12;
    private static final int GCM_TAG_LEN = 16;
    private byte[] iv;
    private byte[] secKey;

    public static SkDkEntity from(byte[] byArray) throws UcsException {
        SkDkEntity skDkEntity;
        SkDkEntity skDkEntity2 = skDkEntity;
        skDkEntity = new SkDkEntity();
        if (byArray.length >= 28) {
            byArray = new byte[12];
            skDkEntity2.iv = byArray;
            System.arraycopy(byArray, 0, byArray, 0, 12);
            byArray = new byte[byArray.length - 12];
            skDkEntity2.secKey = byArray;
            int n2 = byArray.length - 12;
            System.arraycopy(byArray, 12, byArray, 0, n2);
            return skDkEntity2;
        }
        throw new UcsException(1001L, "SK DK format error");
    }

    public byte[] getIv() {
        return this.iv;
    }

    public byte[] getSecKey() {
        return this.secKey;
    }

    public byte[] decryptSkDk(byte[] byArray) throws UcsException {
        try {
            return new AESCipher.Builder().withAlg(CipherAlg.AES_GCM).withIv(this.iv).withKey(new SecretKeySpec(byArray, "AES")).build().getDecryptHandler().from(this.secKey).to();
        }
        catch (CryptoException cryptoException) {
            String string = f.a("decrypt sk dk error : ").append(cryptoException.getMessage()).toString();
            throw new UcsException(1003L, string);
        }
    }
}

