/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wisesecurity.ucs.credential.nativelib;

import android.content.Context;
import android.text.TextUtils;
import com.huawei.wisesecurity.ucs.common.exception.UcsException;
import com.huawei.wisesecurity.ucs.common.log.LogUcs;
import com.huawei.wisesecurity.ucs.credential.entity.EcKeyPair;
import com.huawei.wisesecurity.ucs_credential.f;
import com.huawei.wisesecurity.ucs_credential.h;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class UcsLib {
    private static final String TAG = "UcsLib";
    private static volatile boolean flag = false;
    private static volatile boolean updateRootKeyFlag = false;
    private static final String LIB_NAME = "ucs-credential";
    private static final Charset UTF_8 = StandardCharsets.UTF_8;
    private static final long NATIVE_VERIFY_SIGNATURE_FAIL = 60000L;
    private static final Object CA_LOCK = new Object();

    public static synchronized String loadLibrary() {
        String string = "";
        if (!flag) {
            System.loadLibrary(LIB_NAME);
            String string2 = TAG;
            String string3 = "load lib {0} success";
            Object[] objectArray = new Object[1];
            try {
                objectArray[0] = LIB_NAME;
                LogUcs.i((String)string2, (String)string3, (Object[])objectArray);
                flag = true;
            }
            catch (Throwable throwable) {
                string = f.a("load lib ucs-credential error : ").append(throwable.getMessage()).toString();
                Object[] objectArray2 = new Object[]{};
                LogUcs.e((String)TAG, (String)string, (Object[])objectArray2);
            }
        }
        return string;
    }

    public static void checkNativeLibrary() throws UcsException {
        if (!flag) {
            String string = UcsLib.loadLibrary();
            if (!flag) {
                string = "UCS load library error : " + string;
                throw new UcsException(1004L, string);
            }
        }
    }

    public static boolean isRootKeyUpdated() {
        return updateRootKeyFlag;
    }

    private static native long getSoVersion();

    private static native long updateRootKey(byte[] var0, int var1, OutputParam var2);

    private static native long nativeDecryptKek(byte[] var0, int var1, OutputParam var2);

    private static native long nativeDecryptKekWithEc(byte[] var0, int var1, byte[] var2, byte[] var3, byte[] var4, OutputParam var5);

    private static native long nativeGenReqJws(Context var0, byte[] var1, byte[] var2, long var3, byte[] var5, OutputParam var6);

    private static native long nativeCheckPkgNameCertFP(Context var0, byte[] var1, byte[] var2, OutputParam var3);

    private static native long nativeGetPkgNameCertFP(Context var0, OutputParam var1);

    private static native long nativeGenerateEcKeyPair(Context var0, OutputParam var1);

    public static OutputParam newOutputParam() {
        return new OutputParam();
    }

    public static long ucsGetSoVersion() {
        return UcsLib.getSoVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void ucsUpdateRootKey(byte[] object, int n2) throws UcsException {
        Object object2 = CA_LOCK;
        synchronized (object2) {
            boolean bl;
            long l2;
            Object object3 = UcsLib.newOutputParam();
            {
                void var1_2;
                long l3 = UcsLib.updateRootKey(object, (int)var1_2, (OutputParam)object3) - 0L;
                l2 = l3 == 0L ? 0 : (l3 < 0L ? -1 : 1);
                bl = l2 == false;
            }
            {
                updateRootKeyFlag = bl;
                if (l2 == false) {
                    return;
                }
                object3 = UcsLib.getErrorMessage((OutputParam)object3, "Fail to updateRootKey");
                LogUcs.e((String)TAG, (String)object3, (Object[])new Object[0]);
                throw new UcsException(1009L, (String)object3);
            }
        }
    }

    public static byte[] decryptKek(byte[] object, int n2) throws UcsException {
        byte[] byArray = object;
        OutputParam outputParam = UcsLib.newOutputParam();
        object = outputParam;
        long l2 = UcsLib.nativeDecryptKek(byArray, n2, outputParam);
        if (l2 == 0L) {
            return object.bytes;
        }
        object = UcsLib.getErrorMessage((OutputParam)object, "Fail to decryptKek");
        Object[] objectArray = new Object[]{};
        throw h.a(TAG, (String)object, objectArray, l2, (String)object);
    }

    public static byte[] decryptKekWithEc(byte[] object, int n2, byte[] byArray, byte[] objectArray, byte[] byArray2) throws UcsException {
        long l2 = UcsLib.nativeDecryptKekWithEc(object, n2, byArray, objectArray, byArray2, (OutputParam)(object = (Object)UcsLib.newOutputParam()));
        if (l2 == 0L) {
            return object.bytes;
        }
        object = UcsLib.getErrorMessage((OutputParam)object, "Fail to decryptKekWithEc");
        objectArray = new Object[0];
        throw h.a(TAG, (String)object, objectArray, l2, (String)object);
    }

    public static byte[] genReqJws(Context object, String object2, String object3, int n2, int n3) throws UcsException {
        if (object2 == null) {
            object2 = "";
        }
        if (object != null) {
            if (!TextUtils.isEmpty((CharSequence)object3)) {
                byte[] byArray;
                long l2;
                Context context = object;
                object = UcsLib.newOutputParam();
                long l3 = UcsLib.nativeGenReqJws(context, (byte[])(object2 = (Object)((String)object2).getBytes(StandardCharsets.UTF_8)), (byte[])(object3 = (Object)((String)object3).getBytes(StandardCharsets.UTF_8)), l2 = (long)n2, byArray = String.valueOf(n3).getBytes(StandardCharsets.UTF_8), (OutputParam)object);
                if (l3 == 0L) {
                    return object.bytes;
                }
                object = UcsLib.getErrorMessage((OutputParam)object, "Fail to genReqJws");
                Object[] objectArray = new Object[]{};
                throw h.a(TAG, (String)object, objectArray, l3, (String)object);
            }
            throw new UcsException(1001L, "packageName cannot empty..");
        }
        throw new UcsException(1001L, "context cannot empty..");
    }

    public static boolean checkPkgNameCertFP(Context object, String object2, String string, StringBuilder stringBuilder) {
        if (TextUtils.isEmpty((CharSequence)object2)) {
            stringBuilder.append("appPkgName is null.");
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            stringBuilder.append("appCertFP is null.");
            return false;
        }
        Context context = object;
        object = UcsLib.newOutputParam();
        long l2 = UcsLib.nativeCheckPkgNameCertFP(context, (byte[])(object2 = (Object)((String)object2).getBytes(StandardCharsets.UTF_8)), string.getBytes(StandardCharsets.UTF_8), (OutputParam)object) - 0L;
        long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
        if (l3 != false) {
            stringBuilder.append(UcsLib.getErrorMessage((OutputParam)object, ""));
        }
        return l3 == false;
    }

    public static List<String> getPkgNameCertFP(Context object) throws UcsException {
        ArrayList arrayList;
        Context context = object;
        object = arrayList;
        arrayList = new ArrayList();
        Object[] objectArray = UcsLib.newOutputParam();
        long l2 = UcsLib.nativeGetPkgNameCertFP(context, (OutputParam)objectArray);
        if (l2 == 0L) {
            String string;
            String string2;
            Context context2 = object;
            object = string2;
            string2 = new String(objectArray.bytes, StandardCharsets.UTF_8);
            context2.add(object);
            object = string;
            string = new String(objectArray.secondBytes, StandardCharsets.UTF_8);
            context2.add(object);
            return context2;
        }
        object = UcsLib.getErrorMessage((OutputParam)objectArray, "Fail to getPkgNameCertFP");
        objectArray = new Object[]{};
        throw h.a(TAG, (String)object, objectArray, l2, (String)object);
    }

    public static EcKeyPair generateEcKeyPair(Context object) throws UcsException {
        long l2 = UcsLib.nativeGenerateEcKeyPair(object, (OutputParam)(object = UcsLib.newOutputParam()));
        if (l2 == 0L) {
            return EcKeyPair.newBuilder().publicKey(object.bytes).privateKey(object.secondBytes).build();
        }
        object = UcsLib.getErrorMessage((OutputParam)object, "Fail to nativeGenerateEcKeyPair");
        Object[] objectArray = new Object[]{};
        throw h.a(TAG, (String)object, objectArray, l2, (String)object);
    }

    private static String getErrorMessage(OutputParam object, String object2) {
        String string;
        StringBuilder stringBuilder;
        OutputParam outputParam = object;
        object = stringBuilder;
        new StringBuilder().append((String)object2);
        ((StringBuilder)object).append(", ");
        object2 = outputParam.thirdBytes;
        if (outputParam.thirdBytes != null) {
            String string2;
            string = string2;
            string2 = new String((byte[])object2, StandardCharsets.UTF_8);
        } else {
            string = "errorLog is null.";
        }
        Object object3 = object;
        ((StringBuilder)object3).append(string);
        return ((StringBuilder)object3).toString();
    }

    public static class OutputParam {
        public byte[] bytes = null;
        public byte[] secondBytes = null;
        public byte[] thirdBytes = null;
    }
}

