/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wisesecurity.ucs.common.utils;

import android.text.TextUtils;
import android.util.Base64;
import com.huawei.wisesecurity.ucs.common.exception.UcsException;
import java.nio.charset.StandardCharsets;

public class StringUtil {
    public static boolean checkStringUpperLimit(String string, int n) {
        return string == null || string.length() <= n;
    }

    public static byte[] base64Decode(String string, int n) throws UcsException {
        if (string == null) {
            return new byte[0];
        }
        try {
            return Base64.decode((String)string, (int)n);
        }
        catch (Exception exception) {
            throw new UcsException(1005L, "base64 decode error");
        }
    }

    public static String base64DecodeToString(String string, int n) throws UcsException {
        if (string == null) {
            return "";
        }
        try {
            return new String(Base64.decode((String)string, (int)n), StandardCharsets.UTF_8);
        }
        catch (Exception exception) {
            throw new UcsException(1005L, "base64 decode to string error");
        }
    }

    public static String base64EncodeToString(byte[] byArray, int n) throws UcsException {
        if (byArray != null) {
            try {
                return Base64.encodeToString((byte[])byArray, (int)n);
            }
            catch (Exception exception) {
                throw new UcsException(1005L, "base64 encodeToString error");
            }
        }
        throw new UcsException(1005L, "base64 encodeToString error: data is null");
    }

    public static boolean isLetterDigitHyphens(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        return string.matches("^[a-z0-9A-Z\\-]+$");
    }
}

